package com.testor.module.hazard.controller;

import java.util.ArrayList;
import java.util.List;

import com.testor.module.hazard.model.domain.THazardAssessment;
import com.testor.module.hazard.model.dto.THazardAssessmentDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.hazard.model.dto.THazardAssessmentParam;
import com.testor.module.hazard.model.dto.THazardAssessmentDelParam;
import com.testor.module.hazard.service.THazardAssessmentService;

/**
 * 安全风险分析Controller
 *
 * @author testor-framework
 * @date 2024-12-24 17:17:29
 */
@RestController
@RequestMapping("/hazard/assessment")
@Api(value = "THazardAssessment", tags = "危险作业-安全风险分析")
@Slf4j
public class THazardAssessmentController extends SuperController
{
    @Autowired
    private THazardAssessmentService tHazardAssessmentService;

    /* Generated Method*/
	@ApiOperation(value = "新增 安全风险分析", notes = "Add THazardAssessment")
	@PostMapping(value = "/saveOrUpdate")
	public BaseResponse<THazardAssessment>addEntity(@RequestBody THazardAssessmentDTO tHazardAssessmentDTO) {
		BaseResponse<THazardAssessment> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(tHazardAssessmentDTO)){
			THazardAssessment data = tHazardAssessmentService.addEntity(tHazardAssessmentDTO);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 安全风险分析 ", notes = "Get THazardAssessment By Id")
	@GetMapping(value = "/get")
	public BaseResponse<THazardAssessmentDTO> getById(@RequestParam(value = "workTypeId",required = false) String workTypeId,@RequestParam(value = "planId",required = false) String planId,@RequestParam(value = "completeTime",required = false)  String completeTime){
		BaseResponse<THazardAssessmentDTO> baseResponse=new BaseResponse<>();
		THazardAssessmentDTO data= tHazardAssessmentService.getDetailsById(workTypeId,planId,completeTime);
		baseResponse.setData(data);
		return baseResponse;
	}

	@ApiOperation(value = "修改 安全风险分析 ", notes = "Update THazardAssessment By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody THazardAssessment updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardAssessment data=BeanHelper.beanToBean(updateRequest, THazardAssessment.class);
			boolean result= tHazardAssessmentService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 安全风险分析 ", notes = "delete THazardAssessment By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody THazardAssessmentDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardAssessment data= new THazardAssessment();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tHazardAssessmentService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除安全风险分析", notes = "delete THazardAssessment by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody THazardAssessmentDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<THazardAssessment> tHazardAssessmentList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                THazardAssessment data= new THazardAssessment();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tHazardAssessmentList.add(data);
			}
			boolean result = tHazardAssessmentService.updateBatchById(tHazardAssessmentList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 安全风险分析 分页列表", notes = "List THazardAssessment with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<THazardAssessment>>listEntity(THazardAssessmentParam param){
		BaseResponse<BaseResponseList<THazardAssessment>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<THazardAssessment> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardAssessment> queryWrapper=this.createQuery(param);
		Page<THazardAssessment> resultList= tHazardAssessmentService.page(resultPage,queryWrapper);
		BaseResponseList<THazardAssessment> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 安全风险分析 列表", notes = "List THazardAssessment all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<THazardAssessment>>listAllEntity(THazardAssessmentParam param){
		BaseResponse<BaseResponseList<THazardAssessment>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardAssessment> queryWrapper=this.createQuery(param);
		List<THazardAssessment> resultList=tHazardAssessmentService.list(queryWrapper);
		BaseResponseList<THazardAssessment> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<THazardAssessment> createQuery(THazardAssessmentParam queryParam){
		QueryWrapper<THazardAssessment> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getPlanId())){
			queryWrapper.eq(THazardAssessment.PLAN_ID,queryParam.getPlanId());
		}
		if(StringHelper.isNotEmpty(queryParam.getWorkTypeId())){
			queryWrapper.eq(THazardAssessment.WORK_TYPE_ID,queryParam.getWorkTypeId());
		}
		if(StringHelper.isNotEmpty(queryParam.getParticipantSignature())){
			queryWrapper.eq(THazardAssessment.PARTICIPANT_SIGNATURE,queryParam.getParticipantSignature());
		}
		if(StringHelper.isNotEmpty(queryParam.getSiteImage())){
			queryWrapper.eq(THazardAssessment.SITE_IMAGE,queryParam.getSiteImage());
		}
		if(StringHelper.isNotEmpty(queryParam.getWorkSiteResponsibleSignature())){
			queryWrapper.eq(THazardAssessment.WORK_SITE_RESPONSIBLE_SIGNATURE,queryParam.getWorkSiteResponsibleSignature());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getSignatureTime())){
			queryWrapper.eq(THazardAssessment.SIGNATURE_TIME,queryParam.getSignatureTime());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(THazardAssessment.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(THazardAssessment.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(THazardAssessment.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
