package com.testor.module.hazard.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.hazard.model.domain.THazardConditionConfirmationDetails;
import com.testor.module.hazard.model.dto.THazardConditionConfirmationDetailsParam;
import com.testor.module.hazard.model.dto.THazardConditionConfirmationDetailsDelParam;
import com.testor.module.hazard.service.THazardConditionConfirmationDetailsService;

/**
 * 安全条件确认明细Controller
 *
 * @author testor-framework
 * @date 2024-12-24 21:53:22
 */
@RestController
@RequestMapping("/hazard/confirmationDetails")
@Api(value = "THazardConditionConfirmationDetails", tags = "安全条件确认明细")
@Slf4j
public class THazardConditionConfirmationDetailsController extends SuperController
{
    @Autowired
    private THazardConditionConfirmationDetailsService tHazardConditionConfirmationDetailsService;

    /* Generated Method*/
	@ApiOperation(value = "新增 安全条件确认明细", notes = "Add THazardConditionConfirmationDetails")
	@PostMapping(value = "/add")
	public BaseResponse<THazardConditionConfirmationDetails>addEntity(@RequestBody THazardConditionConfirmationDetails addRequest) {
		BaseResponse<THazardConditionConfirmationDetails> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            THazardConditionConfirmationDetails data=BeanHelper.beanToBean(addRequest,  THazardConditionConfirmationDetails.class);
			data.setId(id);
			boolean result= tHazardConditionConfirmationDetailsService.save(data);
			if(result){
                THazardConditionConfirmationDetails newEntity = new THazardConditionConfirmationDetails();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 安全条件确认明细 ", notes = "Get THazardConditionConfirmationDetails By Id")
	@GetMapping(value = "/get")
	public BaseResponse<THazardConditionConfirmationDetails> getById(String id){
		BaseResponse<THazardConditionConfirmationDetails> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            THazardConditionConfirmationDetails data= tHazardConditionConfirmationDetailsService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 安全条件确认明细 ", notes = "Update THazardConditionConfirmationDetails By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody THazardConditionConfirmationDetails updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardConditionConfirmationDetails data=BeanHelper.beanToBean(updateRequest, THazardConditionConfirmationDetails.class);
			boolean result= tHazardConditionConfirmationDetailsService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 安全条件确认明细 ", notes = "delete THazardConditionConfirmationDetails By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody THazardConditionConfirmationDetailsDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardConditionConfirmationDetails data= new THazardConditionConfirmationDetails();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tHazardConditionConfirmationDetailsService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除安全条件确认明细", notes = "delete THazardConditionConfirmationDetails by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody THazardConditionConfirmationDetailsDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<THazardConditionConfirmationDetails> tHazardConditionConfirmationDetailsList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                THazardConditionConfirmationDetails data= new THazardConditionConfirmationDetails();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tHazardConditionConfirmationDetailsList.add(data);
			}
			boolean result = tHazardConditionConfirmationDetailsService.updateBatchById(tHazardConditionConfirmationDetailsList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 安全条件确认明细 分页列表", notes = "List THazardConditionConfirmationDetails with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<THazardConditionConfirmationDetails>>listEntity(THazardConditionConfirmationDetailsParam param){
		BaseResponse<BaseResponseList<THazardConditionConfirmationDetails>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<THazardConditionConfirmationDetails> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardConditionConfirmationDetails> queryWrapper=this.createQuery(param);
		Page<THazardConditionConfirmationDetails> resultList= tHazardConditionConfirmationDetailsService.page(resultPage,queryWrapper);
		BaseResponseList<THazardConditionConfirmationDetails> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 安全条件确认明细 列表", notes = "List THazardConditionConfirmationDetails all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<THazardConditionConfirmationDetails>>listAllEntity(THazardConditionConfirmationDetailsParam param){
		BaseResponse<BaseResponseList<THazardConditionConfirmationDetails>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardConditionConfirmationDetails> queryWrapper=this.createQuery(param);
		List<THazardConditionConfirmationDetails> resultList=tHazardConditionConfirmationDetailsService.list(queryWrapper);
		BaseResponseList<THazardConditionConfirmationDetails> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<THazardConditionConfirmationDetails> createQuery(THazardConditionConfirmationDetailsParam queryParam){
		QueryWrapper<THazardConditionConfirmationDetails> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getPlanId())){
			queryWrapper.eq(THazardConditionConfirmationDetails.PLAN_ID,queryParam.getPlanId());
		}
		if(StringHelper.isNotEmpty(queryParam.getElement())){
			queryWrapper.eq(THazardConditionConfirmationDetails.ELEMENT,queryParam.getElement());
		}
		if(StringHelper.isNotEmpty(queryParam.getCondition())){
			queryWrapper.eq(THazardConditionConfirmationDetails.CONDITION,queryParam.getCondition());
		}
		if(StringHelper.isNotEmpty(queryParam.getResult())){
			queryWrapper.eq(THazardConditionConfirmationDetails.RESULT,queryParam.getResult());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(THazardConditionConfirmationDetails.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(THazardConditionConfirmationDetails.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(THazardConditionConfirmationDetails.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
