package com.testor.module.hazard.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.hazard.model.domain.THazardLicenseSiteConfirmation;
import com.testor.module.hazard.model.dto.THazardLicenseSiteConfirmationParam;
import com.testor.module.hazard.model.dto.THazardLicenseSiteConfirmationDelParam;
import com.testor.module.hazard.service.THazardLicenseSiteConfirmationService;

/**
 * 危险作业许可证-现场确认记录Controller
 *
 * @author testor-framework
 * @date 2024-12-26 10:53:13
 */
@RestController
@RequestMapping("/hazard/licenseConfirmation")
@Api(value = "THazardLicenseSiteConfirmation", tags = "危险作业许可证-现场确认记录")
@Slf4j
public class THazardLicenseSiteConfirmationController extends SuperController
{
    @Autowired
    private THazardLicenseSiteConfirmationService tHazardLicenseSiteConfirmationService;

    /* Generated Method*/
	@ApiOperation(value = "新增 危险作业许可证-现场确认记录", notes = "Add THazardLicenseSiteConfirmation")
	@PostMapping(value = "/add")
	public BaseResponse<THazardLicenseSiteConfirmation>addEntity(@RequestBody THazardLicenseSiteConfirmation addRequest) {
		BaseResponse<THazardLicenseSiteConfirmation> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            THazardLicenseSiteConfirmation data=BeanHelper.beanToBean(addRequest,  THazardLicenseSiteConfirmation.class);
			data.setId(id);
			boolean result= tHazardLicenseSiteConfirmationService.save(data);
			if(result){
                THazardLicenseSiteConfirmation newEntity = new THazardLicenseSiteConfirmation();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业许可证-现场确认记录 ", notes = "Get THazardLicenseSiteConfirmation By Id")
	@GetMapping(value = "/get")
	public BaseResponse<THazardLicenseSiteConfirmation> getById(String id){
		BaseResponse<THazardLicenseSiteConfirmation> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            THazardLicenseSiteConfirmation data= tHazardLicenseSiteConfirmationService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 危险作业许可证-现场确认记录 ", notes = "Update THazardLicenseSiteConfirmation By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody THazardLicenseSiteConfirmation updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardLicenseSiteConfirmation data=BeanHelper.beanToBean(updateRequest, THazardLicenseSiteConfirmation.class);
			boolean result= tHazardLicenseSiteConfirmationService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 危险作业许可证-现场确认记录 ", notes = "delete THazardLicenseSiteConfirmation By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody THazardLicenseSiteConfirmationDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardLicenseSiteConfirmation data= new THazardLicenseSiteConfirmation();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tHazardLicenseSiteConfirmationService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除危险作业许可证-现场确认记录", notes = "delete THazardLicenseSiteConfirmation by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody THazardLicenseSiteConfirmationDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<THazardLicenseSiteConfirmation> tHazardLicenseSiteConfirmationList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                THazardLicenseSiteConfirmation data= new THazardLicenseSiteConfirmation();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tHazardLicenseSiteConfirmationList.add(data);
			}
			boolean result = tHazardLicenseSiteConfirmationService.updateBatchById(tHazardLicenseSiteConfirmationList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业许可证-现场确认记录 分页列表", notes = "List THazardLicenseSiteConfirmation with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<THazardLicenseSiteConfirmation>>listEntity(THazardLicenseSiteConfirmationParam param){
		BaseResponse<BaseResponseList<THazardLicenseSiteConfirmation>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<THazardLicenseSiteConfirmation> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardLicenseSiteConfirmation> queryWrapper=this.createQuery(param);
		Page<THazardLicenseSiteConfirmation> resultList= tHazardLicenseSiteConfirmationService.page(resultPage,queryWrapper);
		BaseResponseList<THazardLicenseSiteConfirmation> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业许可证-现场确认记录 列表", notes = "List THazardLicenseSiteConfirmation all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<THazardLicenseSiteConfirmation>>listAllEntity(THazardLicenseSiteConfirmationParam param){
		BaseResponse<BaseResponseList<THazardLicenseSiteConfirmation>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardLicenseSiteConfirmation> queryWrapper=this.createQuery(param);
		List<THazardLicenseSiteConfirmation> resultList=tHazardLicenseSiteConfirmationService.list(queryWrapper);
		BaseResponseList<THazardLicenseSiteConfirmation> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<THazardLicenseSiteConfirmation> createQuery(THazardLicenseSiteConfirmationParam queryParam){
		QueryWrapper<THazardLicenseSiteConfirmation> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getPlanId())){
			queryWrapper.eq(THazardLicenseSiteConfirmation.PLAN_ID,queryParam.getPlanId());
		}
		if(StringHelper.isNotEmpty(queryParam.getLicenseId())){
			queryWrapper.eq(THazardLicenseSiteConfirmation.LICENSE_ID,queryParam.getLicenseId());
		}
		if(StringHelper.isNotEmpty(queryParam.getType())){
			queryWrapper.eq(THazardLicenseSiteConfirmation.TYPE,queryParam.getType());
		}
		if(StringHelper.isNotEmpty(queryParam.getIsOnSiteAssignee())){
			queryWrapper.eq(THazardLicenseSiteConfirmation.IS_ON_SITE_ASSIGNEE,queryParam.getIsOnSiteAssignee());
		}
		if(StringHelper.isNotEmpty(queryParam.getAssignSiteConfirmor())){
			queryWrapper.eq(THazardLicenseSiteConfirmation.ASSIGN_SITE_CONFIRMOR,queryParam.getAssignSiteConfirmor());
		}
		if(StringHelper.isNotEmpty(queryParam.getConfirmationResult())){
			queryWrapper.eq(THazardLicenseSiteConfirmation.CONFIRMATION_RESULT,queryParam.getConfirmationResult());
		}
		if(StringHelper.isNotEmpty(queryParam.getConfirmationOpinion())){
			queryWrapper.eq(THazardLicenseSiteConfirmation.CONFIRMATION_OPINION,queryParam.getConfirmationOpinion());
		}
		if(StringHelper.isNotEmpty(queryParam.getSiteImages())){
			queryWrapper.eq(THazardLicenseSiteConfirmation.SITE_IMAGES,queryParam.getSiteImages());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(THazardLicenseSiteConfirmation.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(THazardLicenseSiteConfirmation.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(THazardLicenseSiteConfirmation.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
