package com.testor.module.hazard.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 危险作业监测记录项目对象 t_hazard_work_plan_monitoring_record_project
 *
 * @author testor-framework
 * @date 2025-01-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_hazard_work_plan_monitoring_record_project")
@ApiModel(value = "THazardWorkPlanMonitoringRecordProject对象", description = "危险作业监测记录项目")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class THazardWorkPlanMonitoringRecordProject extends SuperModel
{
    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    @TableId("id")
    private String id;

    /**
     * 项目名称
     */
    @ApiModelProperty(value = "项目名称")
    @TableField("project_name")
    private String projectName;

    /**
     * 项目值
     */
    @ApiModelProperty(value = "项目值")
    @TableField("project_value")
    private String projectValue;

    /**
     * 危险作业监测记录表id
     */
    @ApiModelProperty(value = "危险作业监测记录表id")
    @TableField("hazard_work_plan_monitoring_record_id")
    private String hazardWorkPlanMonitoringRecordId;

    // 常量定义
    public static final String ID = "id";
    public static final String PROJECT_NAME = "project_name";
    public static final String PROJECT_VALUE = "project_value";
    public static final String HAZARD_WORK_PLAN_MONITORING_RECORD_ID = "hazard_work_plan_monitoring_record_id";
    public static final String STATUS = "status";
}