package com.testor.module.hazard.model.dto;

import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.datetime.DatetimeHelper;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
public class TaskInfoDTO {
    private String taskId;
    private String taskName;
    private String status; // COMPLETED, ASSIGNED, UNCLAIMED
    private String assignee;
    private Date startTime;
    private Date endTime;
    private LocalDateTime completeTime;

    private String comment;
    @ApiModelProperty("可签收的用户")
    private List<String> candidateUsers; // 可签收的用户

    @ApiModelProperty("可签收的组")
    private List<String> candidateGroups; // 可签收的组

    private Map<String,Object> vars;

    public void setEndTime(Date endTime) {
        this.endTime = endTime;

        if (ObjectHelper.isNotEmpty(endTime)) {
            this.completeTime = DatetimeHelper.of(endTime.getTime());
        }
    }
}