package com.testor.module.hazard.model.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class HazardWorkPlanStatisticsVO implements Serializable {
    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "横坐标数据id(单位id)")
    private String coordinateId;

    @ApiModelProperty(value = "横坐标数据名称(单位名称)")
    private String coordinateName;

    @ApiModelProperty(value = "数量")
    private String num;

    @ApiModelProperty(value = "层次级别，1顶级依次类推")
    private BigDecimal treeLevel;

    @ApiModelProperty(value = "企业性质（字典类型：NATURE）")
    private String nature;

    @ApiModelProperty(value = "横坐标日期数据")
    private String timeStr;

    /**
     * 相关方作业
     */
    @ApiModelProperty(value = "相关方作业")
    private String stakeholderWork;

    /**
     * 相关方作业率
     */
    @ApiModelProperty(value = "相关方作业占比")
    private BigDecimal rate;

    @ApiModelProperty(value = "是否租赁库")
    private String isRent;

    @ApiModelProperty(value = "危险作业人员")
    private String operator;
}
