package com.testor.module.hazard.service;

import com.testor.module.hazard.model.dto.HazardWorkPlanStatisticsDto;
import com.testor.module.hazard.model.vo.HazardWorkPlanStatisticsVO;

import java.util.List;

public interface HazardWorkPlanStatisticsService {
    /**
     * 危险作业分布统计，根据单位
     * @param param
     * @return
     */
    public List<HazardWorkPlanStatisticsVO> statWorkPlanNumByOrg(HazardWorkPlanStatisticsDto param);

    /**
     * 危险作业数量统计，根据时间
     * @param param
     * @return
     */
    public List<HazardWorkPlanStatisticsVO> statWorkPlanNumByTime(HazardWorkPlanStatisticsDto param);

    /**
     * 相关方作业统计
     * @param param
     * @return
     */
    public List<HazardWorkPlanStatisticsVO> statStakeholderWorkNum(HazardWorkPlanStatisticsDto param);

    /**
     * 租赁库占比统计
     * @param param
     * @return
     */
    public List<HazardWorkPlanStatisticsVO> statIsRentNum(HazardWorkPlanStatisticsDto param);

    /**
     * 危险作业人员统计
     * @param param
     * @return
     */
    public List<HazardWorkPlanStatisticsVO> statOperatorNum(HazardWorkPlanStatisticsDto param);
}
