package com.testor.module.hazard.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.module.hazard.dao.THazardWorkPlanDao;
import com.testor.module.hazard.dao.TrainExaminationManageRetakeDao;
import com.testor.module.hazard.model.domain.THazardWorkPlan;
import com.testor.module.hazard.model.domain.TrainExaminationManageRetake;
import com.testor.module.hazard.model.dto.THazardWorkPlanParam;
import com.testor.module.hazard.model.dto.TrainExaminationManageRetakeParam;
import com.testor.module.hazard.model.enums.WorkPlanStatusEnum;
import com.testor.module.hazard.service.THazardWorkPlanService;
import com.testor.module.hazard.service.TrainExaminationManageRetakeService;
import com.testor.module.sys.model.domian.NewSysOrg;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class TrainExaminationManageRetakeServiceImpl extends SuperServiceImpl<TrainExaminationManageRetakeDao, TrainExaminationManageRetake> implements TrainExaminationManageRetakeService {


    private QueryWrapper<TrainExaminationManageRetake> createQuery(TrainExaminationManageRetakeParam queryParam) {
        QueryWrapper<TrainExaminationManageRetake> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getTrainExaminationManageId())) {
            queryWrapper.eq("train_examination_manage_id", queryParam.getTrainExaminationManageId());
        }
        return queryWrapper;
    }

    @Override
    public void updateTrainExaminationManageRetake(TrainExaminationManageRetake trainExaminationManageRetake) {
        baseMapper.updateById(trainExaminationManageRetake);
    }

    @Override
    public void insertTrainExaminationManageRetake(TrainExaminationManageRetake trainExaminationManageRetake) {
        baseMapper.insert(trainExaminationManageRetake);
    }

    @Override
    public TrainExaminationManageRetake getByTrainExaminationManageId(String trainExaminationManageId) {
        return baseMapper.getByTrainExaminationManageId(trainExaminationManageId);
    }
}


