package com.testor.module.news.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;


/**
 * 新闻模块对象 t_sys_news
 *
 * @author gaobingzhuo@testor.com.cn
 * @date 2022-05-07 14:02:06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_sys_news")
@ApiModel(value = "SysNews对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class SysNews extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 新闻id
     */
    @ApiModelProperty(value = "新闻id", required = true)

    @TableId("id")
    private String id;
    /**
     * 发布单位
     */
    @ApiModelProperty(value = "发布单位")

    @TableField("release_unit")
    private String releaseUnit;
    /**
     * 新闻标题
     */
    @ApiModelProperty(value = "新闻标题", required = true)

    @TableField("title")
    private String title;
    /**
     * 新闻内容
     */
    @ApiModelProperty(value = "新闻内容", required = true)

    @TableField("content")
    private String content;

    /**
     * 审核状态  3 提交（待审核）4 草稿 5 审核通过 6 撤销发布 7 驳回（审核失败）
     */
    @ApiModelProperty(value = "审核状态  3 提交（待审核）4 草稿 5 审核通过 6 撤销发布 7 驳回（审核失败）")
    @TableField("process_status")
    private String processStatus;
    /**
     * 流程实例id
     */
    @ApiModelProperty(value = "流程实例id")

    @TableField("process_id")
    private String processId;
    /**
     * 父级id
     */
    @ApiModelProperty(value = "父级id")

    @TableField("parent_id")
    private String parentId;
    /**
     * 驳回意见
     */
    @ApiModelProperty(value = "驳回意见")

    @TableField("reject_opinion")
    private String rejectOpinion;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;

    @ApiModelProperty(value = "发布时间")
    @TableField("release_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date releaseTime;
    /**
     * 发布单位所属组织机构层级
     */
    @ApiModelProperty(value = "发布单位所属组织机构层级")

    @TableField("\"level\"")
    private BigDecimal level;

    @ApiModelProperty(value = "发布单位所属组织机构层级的id")
    @TableField("release_org_id")
    private String releaseOrgId;

    @ApiModelProperty(value = "接收对象")
    @TableField("receiver_obj")
    private String receiverObj;

    @ApiModelProperty(value = "接收对象类型")
    @TableField("receiver_type")
    private String receiverType;


    @ApiModelProperty(value = "1 已读 0 未读")
    private String isRead;

    public static final String ID = "id";
    public static final String RELEASE_UNIT = "release_unit";
    public static final String TITLE = "title";
    public static final String CONTENT = "content";
    public static final String IS_READ = "is_read";
    public static final String PROCESS_STATUS = "process_status";
    public static final String PROCESS_ID = "process_id";
    public static final String PARENT_ID = "parent_id";
    public static final String REJECT_OPINION = "reject_opinion";
    public static final String TENANT_ID = "tenant_id";
    public static final String RELEASE_ORG_ID = "release_org_id";


}
