package com.testor.module.safe.model.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import org.apache.poi.sl.usermodel.PictureData;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 隐患报告实体类
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class HiddenDangerTemplate {

    /**
     * 隐患单位名称
     */
    @ExcelProperty(value = "隐患单位名称", index = 0)
    private String hazardUnitName;

    /**
     * 隐患单位编码
     */
    @ExcelProperty(value = "隐患单位编码", index = 1)
    private String orgId;

    /**
     * 隐患名称
     */
    @ExcelProperty(value = "隐患名称", index = 2)
    private String name;

    /**
     * 发现形式编码
     */
    @ExcelProperty(value = "发现形式编码", index = 3)
    private String checkType;

    /**
     * 隐患位置
     */
    @ExcelProperty(value = "隐患位置", index = 4)
    private String location;

    /**
     * 隐患描述
     */
    @ExcelProperty(value = "隐患描述", index = 5)
    private String remarks;

    /**
     * 是否重复隐患
     */
    @ExcelProperty(value = "是否重复隐患", index = 6)
    private Boolean isDuplicateHazard;

    /**
     * 隐患级别
     */
    @ExcelProperty(value = "隐患级别", index = 7)
    private String level;

    /**
     * 隐患图片1
     */
    @ExcelProperty(value = "隐患图片1", index = 8)
    private PictureData hazardImage1;

    /**
     * 隐患图片2
     */
    @ExcelProperty(value = "隐患图片2", index = 9)
    private PictureData hazardImage2;

    /**
     * 隐患图片3
     */
    @ExcelProperty(value = "隐患图片3", index = 10)
    private String hazardImage3;

    /**
     * 是否转工单
     */
    @ExcelProperty(value = "是否转工单", index = 11)
    private Boolean isTransferredToWorkOrder;

    /**
     * 隐患分类
     */
    @ExcelProperty(value = "隐患分类", index = 12)
    private String classify;

    /**
     * 隐患类型
     */
    @ExcelProperty(value = "隐患类型", index = 13)
    private String hazardType;

    /**
     * 法规依据
     */
    @ExcelProperty(value = "法规依据", index = 14)
    private String rule;

    /**
     * 整改前防范措施
     */
    @ExcelProperty(value = "整改前防范措施", index = 15)
    private String guardAgainst;

    /**
     * 整改人
     */
    @ExcelProperty(value = "整改人", index = 16)
    private String rectifyPeople;

    /**
     * 验收人
     */
    @ExcelProperty(value = "验收人", index = 17)
    private String acceptance;

    /**
     * 整改日期
     */
    @ExcelProperty(value = "整改日期", index = 18)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date correctionDate;
}

