package com.testor.module.safe.model.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;


/**
 * 巡检排查标准管理对象 t_safe_hazard_standard_type
 *
 * @author testor-framework
 * @date 2022-08-08 10:55:55
 */
@Data
@ApiModel(value = "TSafeHazardStandardType对象", description = "")
public class TSafeHazardStandardTypeEditDTO extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    private String id;

    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")
    private String parentId;


    /**
     * 标准分类名称
     */
    @ApiModelProperty(value = "标准分类名称")
    @TableField("name")
    private String name;

    /**
     * 具体分类项
     */
    @ApiModelProperty(value = "具体分类项")
    private String categoryItem;

    /**
     * 是否系统内置（0-否；1-是）
     */
    @ApiModelProperty(value = "是否系统内置（0-否；1-是）")
    private String builtIn;

    /**
     * 整改前后照片（0-非必填；1-必填）
     */
    @ApiModelProperty(value = "整改前后照片（0-非必填；1-必填）")
    private String image;

    /**
     * 排序
     */
    @ApiModelProperty(value = "排序", example = "0")
    private Integer sort;

    /**
     * 级别
     */
    @ApiModelProperty(value = "级别", example = "0")
    private Integer level;

    @TableField("precautions")
    private String precautions;

    @ApiModelProperty("子项")
    private List<TSafeHazardStandardTypeEditDTO> standardTypeEditDTOS;
}
