package com.testor.module.safe.service;


import com.testor.module.safe.model.domain.TSafeHazardOrg;
import com.testor.module.safe.model.dto.TSafeHazardOrgDTO;
import com.testor.module.safe.model.dto.TSafeHazardOrgParam;
import com.testor.module.safe.model.vo.*;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperService;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 隐患上报台账Service接口
 *
 * @author testor-framework
 * @date 2022-08-04 14:01:01
 */
public interface TSafeHazardOrgService extends SuperService<TSafeHazardOrg> {

    BaseResponse<BaseResponseList<TSafeHazardOrgDTO>> listEntity(TSafeHazardOrgParam param);

    BaseResponse<BaseResponseList<TSafeHazardOrgDTO>> listEntityTodoList(TSafeHazardOrgParam param);

    void createOrgTask(String id);

    /**
     * 隐患统计
     *
     * @param tSafeHazardOrgParam
     * @return
     */
    List<TSafeHazardOrgStatisticsVO> hiddenDangerStatistics(TSafeHazardOrgParam tSafeHazardOrgParam);

    /**
     * 根据功能配置类型统计-柱状图
     *
     * @param tSafeHazardOrgParam
     * @return
     */
    List<TSafeHazardOrgStatisticsTypeVO> hiddenStatisticsHistogram(TSafeHazardOrgParam tSafeHazardOrgParam);

    /**
     * 根据页面配置类型统计-饼图
     *
     * @param tSafeHazardOrgParam
     * @return
     */
    List<TSafeHazardOrgStatisticsTypeVO> hiddenStatisticsPieChart(TSafeHazardOrgParam tSafeHazardOrgParam);

    /**
     * 首页 - 隐患治理 - 隐患数量统计列表
     *
     * @param orgIds
     * @param treeLevel
     * @return
     */
    List<HiddenDangerVO> getHiddenDangerNumber(List<String> orgIds, int treeLevel);
    List<HiddenDangerVO> getHiddenDanger(List<String> orgIds);

    Boolean exportEntity(TSafeHazardOrgParam param, HttpServletResponse response);

    void buildData();

    int getHiddenDangerCount(String orgId);

    boolean importData(MultipartFile file, TSafeHazardOrgParam param);

    boolean exportTemplate(HttpServletResponse response, String planId);

    TSafeHazardOrg getDetails(String id);

    boolean saveData(TSafeHazardOrgParam addRequest);

    List<HiddenStatisticsVo> hiddenTypeStatistics(TSafeHazardOrgParam param);

    List<TSafeHazardOrgStatisticsTypeVO> hiddenStatisticsByConditions(TSafeHazardOrgParam param);
}
