package com.testor.module.safeCheck.dao;

import com.testor.module.safeCheck.model.domain.TSafeHazardCheckPeople;
import com.testor.module.safeCheck.model.vo.SafeHazardCheckPeopleVO;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 巡检人员Mapper接口
 *
 * @author testor-framework
 * @date 2022-08-04 11:07:50
 */
public interface TSafeHazardCheckPeopleDao extends SuperDao<TSafeHazardCheckPeople>
{
    /**
     *
     * @param planId
     * @return
     */
    List<SafeHazardCheckPeopleVO> listVOByPlan(@Param("planId") String planId);

    /**
     * 查询指定时间 正在进行的 巡检计划 下的 巡检人员对象信息
     * @param doingDate 指定时间
     * @return
     */
    List<TSafeHazardCheckPeople> listDoingVOByPlanDate(@Param("doingDate") String doingDate);


}
