package com.testor.module.safeCheck.model.domain;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 安全检查计划任务对象 t_safe_check_task
 * 
 * @author testor-framework
 * @date 2024-09-03 08:04:19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_check_task")
@ApiModel(value = "TSafeCheckTask对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeCheckTask extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")

  @TableId("id")
  private String id;
/**
 * 安全检查计划id
 */
  @ApiModelProperty(value = "安全检查计划id")

  @TableField("plan_id")
  private String planId;

  /**
   * 排查单位id
   */
  @ApiModelProperty(value = "排查单位id")

  @TableField("org_id")
  private String orgId;

  @ApiModelProperty(value = "排查单位名称")
  @TableField(exist = false)
  private String orgName;

  /**
   * 排查单位ids
   */
  @ApiModelProperty(value = "排查单位ids")
  @TableField(exist = false)
  private String orgIds;

  /**
   * 排查单位ids
   */
  @ApiModelProperty(value = "排查单位ids")
  @TableField(exist = false)
  private List<String> orgIdList;


  /**
   * t_safe_chek_person表关联id
   */
  @ApiModelProperty(value = "t_safe_chek_person表关联id")

  @TableField("check_person_id")
  private String checkPersonId;

  /**
   * 任务名称
   */
  @ApiModelProperty(value = "任务名称")

  @TableField("name")
  private String name;

  /**
   * 检查类型
   */
  @ApiModelProperty(value = "检查类型(字典值)")

  @TableField("check_type")
  private String checkType;

  /**
   * 检查类型
   */
  @ApiModelProperty(value = "检查类型(字典值)")
  @TableField(exist = false)
  private String checkTypeName;

/**
 * 流程状态
 */
  @ApiModelProperty(value = "任务状态")

  @TableField(exist = false)
  private String taskStatus;

  /**
   * 流程状态
   */
  @ApiModelProperty(value = "任务状态名称")

  @TableField(exist = false)
  private String taskStatusName;

/**
 * 是否预期 0否 1是
 */
  @ApiModelProperty(value = "是否逾期 0否 1是")

  @TableField("is_overdue")
  private String isOverdue;

  /**
   * 初始任务结束时间
   */
  @ApiModelProperty(value = "初始任务结束时间")

  @TableField("initial_end_date")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date initialEndDate;

/**
 * 任务开始时间
 */
  @ApiModelProperty(value = "任务开始时间")

  @TableField("start_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startTime;
/**
 * 任务结束时间
 */
  @ApiModelProperty(value = "任务结束时间")

  @TableField("end_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;
/**
 * 任务完成时间
 */
  @ApiModelProperty(value = "任务完成时间")

  @TableField("complete_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date completeTime;

  @ApiModelProperty(value = "检查人员")
  @TableField(exist = false)
  private String checkPeople;

  public static final String ID ="id";
  public static final String PLAN_ID ="plan_id";
  public static final String PROCESS_ID ="process_id";
  public static final String PROCESS_STATUS ="process_status";
  public static final String CHECK_PERSON_ID ="check_person_id";
  public static final String IS_OVERDUE ="is_overdue";
  public static final String START_TIME ="start_time";
  public static final String END_TIME ="end_time";
  public static final String COMPLETE_TIME ="complete_time";

  public enum TaskStatus {
    NOT_STARTED("0", "未开始"),
    IN_PROGRESS("1", "进行中"),
    COMPLETED("2", "已完成");

    private final String code;
    private final String name;

    TaskStatus(String code, String name) {
      this.code = code;
      this.name = name;
    }

    public String getCode() {
      return code;
    }

    public String getName() {
      return name;
    }

    public static TaskStatus fromCode(String code) {
      for (TaskStatus status : TaskStatus.values()) {
        if (status.code.equals(code)) {
          return status;
        }
      }
      throw new IllegalArgumentException("Unknown code: " + code);
    }
  }


}
