package com.testor.module.safeCheck.service;


import com.testor.module.safeCheck.model.domain.TSafeHazardCheckObject;
// import com.testor.module.safeCheck.model.vo.SafeHazardCheckObjectGroupVO;
import com.testor.module.safeCheck.model.vo.SafeHazardCheckObjectVO;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

/**
 * 巡检对象Service接口
 * 
 * @author testor-framework
 * @date 2022-08-04 11:07:48
 */
public interface TSafeHazardCheckObjectService extends SuperService<TSafeHazardCheckObject> {

//    /**
//     * @param checkObjectDTOList
//     * @return
//     */
//    boolean editBatch(List<TSafeHazardCheckObjectDTO> checkObjectDTOList);

//    BaseResponse editCheckObject(TSafeHazardCheckObject checkObject);

//    /**
//     * 查询排查对象列表 ，按 对象分类、 排查标准 分组查询
//     * @param checkObject
//     * @return
//     */
//    List<SafeHazardCheckObjectGroupVO> listByGroup(TSafeHazardCheckObject checkObject);

    /**
     * 根据巡检计划id 查询 巡检对象
     * @param planId
     * @return
     */
    List<TSafeHazardCheckObject> listByPlan(String planId);

    /**
     * 根据 巡检计划 编辑 巡检对象（新增、修改、删除的处理）
     * @param planId
     * @param checkObjectList
     * @return
     */
    boolean editBatchByPlan(String planId, List<TSafeHazardCheckObject> checkObjectList);

    /**
     * @param planId
     * @return
     */
    List<SafeHazardCheckObjectVO> listVOByPlan(String planId);

    /**
     * 根据巡检计划，获取对象名称字符串
     * @param planId
     * @return
     */
    String findObjectNamesByPlan(String planId);
}
