package com.testor.module.safeCheck.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.testor.common.constant.StatusEnum;
import com.testor.module.safeCheck.dao.TSafeCheckTaskRecordDao;
import com.testor.module.safeCheck.model.domain.TSafeCheckTaskRecord;
import com.testor.module.safeCheck.service.TSafeCheckTaskRecordService;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.List;

/**
 * 安全检查任务流程记录Service业务层处理
 * 
 * @author testor-framework
 * @date 2024-09-05 09:25:46
 */
@Service
public class TSafeCheckTaskRecordServiceImpl extends SuperServiceImpl<TSafeCheckTaskRecordDao, TSafeCheckTaskRecord> implements TSafeCheckTaskRecordService
{
    @Autowired(required = false)
    private TSafeCheckTaskRecordDao tSafeCheckTaskRecordDao;

    @Override
    public List<TSafeCheckTaskRecord> findUserRecordByTaskId(String taskId) {
        return this.list(new LambdaQueryWrapper<TSafeCheckTaskRecord>()
                .eq(TSafeCheckTaskRecord::getTaskId, taskId).eq(TSafeCheckTaskRecord::getRefType, 1)
                .eq(TSafeCheckTaskRecord::getStatus, StatusEnum.USE.getCode()));

    }

    @Override
    public List<TSafeCheckTaskRecord> findHazardRecordByTaskId(String taskId) {
        return this.list(new LambdaQueryWrapper<TSafeCheckTaskRecord>()
                .eq(TSafeCheckTaskRecord::getTaskId, taskId).eq(TSafeCheckTaskRecord::getRefType, 2)
                .eq(TSafeCheckTaskRecord::getStatus, StatusEnum.USE.getCode()));
    }
}
