package com.testor.module.sys.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.testor.module.sys.dao.SysUserExtendDao;
import com.testor.module.sys.model.domian.SysUserExtend;
import com.testor.module.sys.service.SysUserExtendService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * <p>
 * 用户表 服务实现类
 * </p>
 *
 * @author caoqiang
 * @since 2024-09-03
 */
@Service
public class SysUserExtendServiceImpl extends ServiceImpl<SysUserExtendDao, SysUserExtend> implements SysUserExtendService {

    @Override
    public void addOrUpdateUserType(String userId, String userTypeCode) {
        if (StringUtils.isBlank(userId) || StringUtils.isBlank(userTypeCode)) {
            return;
        }
        SysUserExtend sysUserExtend = new SysUserExtend();
        sysUserExtend.setUserId(userId);
        sysUserExtend.setUserTypeCode(userTypeCode);
        sysUserExtend.setCreateDate(new Date());
        sysUserExtend.setUpdateDate(new Date());
        this.saveOrUpdate(sysUserExtend);

    }
}
