package com.testor.module.train.course.model.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.testor.module.train.course.model.domain.TTrainSmallNode;

/**
 * 课程小节—安全培训教育 删除参数对象
 *
 * @author testor-framework
 * @date 2022-07-25 18:10:52
 */

@Data
@ApiModel(value = "TTrainSmallNode 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TTrainSmallNodeParam extends TTrainSmallNode {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	@ApiModelProperty(value = "名称")
	private String fileName;

	@ApiModelProperty(value = "路径")
	private String filePath;

	@TableField("small_plan")
	private String smallPlan;

}
