package com.testor.module.train.myManagement.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.testor.module.train.course.model.dto.TTrainCourseParam;
import com.testor.module.train.exam.model.domain.TTrainQuestionBank;
import com.testor.module.train.examinationManage.model.dto.TTrainExaminationManageQueryParam;
import com.testor.module.train.myManagement.model.domain.TTrainCourseLearnStatistics;
import com.testor.module.train.myManagement.model.domain.TTrainMyManagement;
import com.testor.module.train.myManagement.model.dto.TTrainMyManagementParam;
import com.testor.module.train.paper.model.dto.ReturnTrainPaper;
import com.testor.module.train.project.model.dto.MyManagement;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

/**
 * 我的培训教育及考试—安全培训教育Service接口
 *
 * @author testor-framework
 * @date 2022-07-28 15:25:02
 */
public interface TTrainMyManagementService extends SuperService<TTrainMyManagement> {
    //保存课程或考试
    BaseResponse<TTrainMyManagement> addEntity(List<MyManagement> addRequest);
    // 教育培训编辑时删除编辑前的人员
    void deletePerson(String id);
    // 教育培训获取详情
    List<TTrainMyManagement> getPerson(String projectParamId);

    // 教育培训获取详情
    List<TTrainMyManagement> getPerson(String projectParamId,String orgId,String name,String status);

    // 员工培训情况-培训计划
    IPage<TTrainMyManagementParam> staffTrainCase(TTrainMyManagementParam param,String parentIds,String orgId);

    // 添加课程到我的学习里面
    void addCourse(MyManagement myManagement) throws Exception;

    BaseResponse<List<TTrainCourseParam>> startLearn(TTrainMyManagement tTrainMyManagement) throws Exception;

    BaseResponse<TTrainCourseParam> getCourseDetail(String id,String taskId)throws Exception;

    BaseResponse<TTrainCourseLearnStatistics> planStatistics(List<TTrainCourseLearnStatistics> courseLearnStatistics)throws Exception;

    BaseResponse<TTrainMyManagement> lineTrainSign(String id) throws Exception;

    BaseResponse<BizGeneralResponse> updateEntity(List<TTrainMyManagement> updateRequest);

    BaseResponse<List<TTrainQuestionBank>> getTestBlankName();

    /**
     * @description TODO 扫码考试
     * @param id
     * @return com.tongtech.tfw.backend.common.biz.models.BaseResponse<com.testor.module.train.myManagement.model.domain.TTrainMyManagement>
     * @author qiao
     * @date 4/17/23 5:20 PM
     */
    BaseResponse<TTrainExaminationManageQueryParam> scanCodeExam(String id) throws Exception;

    /**
     * @description TODO 扫码考试-开始考试
     * @param id
     * @return com.tongtech.tfw.backend.common.biz.models.BaseResponse<com.testor.module.train.examinationManage.model.dto.TTrainExaminationManageQueryParam>
     * @author qiao
     * @date 4/21/23 10:53 AM
     */
    BaseResponse<ReturnTrainPaper> startExam(String id);

    /**
     * @description   查询项目所有课程是否完成
     */
    BaseResponse<Boolean> findAllProjectCourseCompleteState(TTrainMyManagement tTrainMyManagement) throws Exception;


}
