package com.testor.module.train.myManagement.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.testor.module.train.myManagement.model.domain.TTrainTestQuestionsExercise;
import com.testor.module.train.myManagement.model.dto.TTrainTestQuestionsExerciseParam;
import com.testor.module.train.paper.model.dto.ReturnTrainPaper;
import com.testor.module.train.paper.model.dto.TestQuestionsContent;
import com.testor.module.train.project.model.dto.Exercise;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperService;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 我的试题练习、考试—安全培训教育Service接口
 * 
 * @author testor-framework
 * @date 2022-08-08 10:16:57
 */
public interface TTrainTestQuestionsExerciseService extends SuperService<TTrainTestQuestionsExercise> {

    BaseResponse<TTrainTestQuestionsExercise> saveClose(List<TTrainTestQuestionsExercise> questBody)throws Exception;

    BaseResponse<BizGeneralResponse> againExercise(List<String> id);


    IPage<TTrainTestQuestionsExercise> errorRecord(TTrainTestQuestionsExerciseParam param,String userId);

    BaseResponse<BaseResponseList<TestQuestionsContent>> getTestQuestions(Exercise exercise) throws Exception;

    BaseResponse<ReturnTrainPaper> startExamine(String id)throws Exception;

    BaseResponse<TTrainTestQuestionsExercise> submitTestPaper(List<TTrainTestQuestionsExercise> questBody) throws Exception;

    BaseResponse<ReturnTrainPaper> getTestPaperDetail(String id) throws Exception;
    /**
     * 开始补考考试
     * @param id
     * @return
     * @throws Exception
     */
    BaseResponse<ReturnTrainPaper> startExamineRetake(String id)throws Exception;


    /**
     * 根据考试id查询补考记录
     * @param parentId
     * @return
     */
    List<TTrainTestQuestionsExercise> getByExaminationId(String id,String userId);

    /**
     * 获取补考考试详情
     * @param id
     * @return
     * @throws Exception
     */
    BaseResponse<ReturnTrainPaper> getTestPaperRetakeDetail(String id) throws Exception;

    List<TTrainTestQuestionsExercise> getByMyIdAndCreateBy(String id,String createBy);


}
