package com.testor.module.wf.utils;
 
import com.alibaba.fastjson.util.TypeUtils;
import org.apache.commons.lang.StringUtils;
 
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
 
/**
 * 变量工具类
 */
public class VariableUtils {
 
    /**
     * 格式化变量名，去除${}符号
     * @param variableName 变量名
     * @return 变量名
     */
    public static String formatVariableName(String variableName) {
        variableName = variableName.replaceAll("[${}]", "").trim();
        return variableName;
    }
 
    /**
     * 获取格式化后的变量值
     * @param variableType 变量类型
     * @param variableValue 变量值
     * @return 格式化后的变量值
     */
    public static Object getFormatVariableValue(String variableType, String variableValue) {
        if (StringUtils.isBlank(variableType)) {
            throw new RuntimeException("变量类型为空！");
        }
        if (!"java.lang.String".equals(variableType) && StringUtils.isBlank(variableValue)) {
            throw new RuntimeException("变量值为空！");
        }
 
        Object value;
        try {
            switch (variableType) {
                case "java.lang.String": //字符串
                    value = variableValue;
                    break;
                case "java.lang.Integer": //整数
                    value = new Integer(variableValue);
                    break;
                case "java.math.BigDecimal": //金额
                    value = new BigDecimal(variableValue);
                    break;
                case "java.util.ArrayList": //列表
                    String[] split = variableValue.split(",");
                    value = new ArrayList<>(Arrays.asList(split));
                    break;
                default:
                    // 不是以上的类型！但愿可以通过反射注入吧！
                    Class<?> aClass = Class.forName(variableType);
//                    Constructor<?> constructor = aClass.getConstructor(String.class);
//                    value = constructor.newInstance(variableValue);
 
                    value = TypeUtils.castToJavaBean(variableValue, aClass);
                    break;
            }
        } catch (Exception e) {
            e.printStackTrace();
 
            throw new RuntimeException(e.getMessage(), e);
        }
 
        return value;
    }
 
}