/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.auth.interceptor;

import com.testor.biz.auth.model.AuthModel;
import com.testor.biz.auth.model.RoleResourceModel;
import com.testor.biz.auth.service.AuthService;
import com.tongtech.tfw.backend.common.constants.enumeration.BaseStatusEnum;
import com.tongtech.tfw.backend.common.constants.enumeration.HttpStatusCodeEnum;
import com.tongtech.tfw.backend.common.jwt.JwtHelper;
import com.tongtech.tfw.backend.common.models.jwt.JwtInfos;
import com.tongtech.tfw.backend.common.models.response.ResponseInfo;
import com.tongtech.tfw.backend.common.request.RequestUtil;
import com.tongtech.tfw.backend.common.response.ResponseUtil;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import io.jsonwebtoken.ExpiredJwtException;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.util.UrlPathHelper;

public class AuthInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthInterceptor.class);
    @Autowired
    private PathMatcher pathMatcher;
    @Autowired
    private AuthService authService;
    @Autowired
    private UrlPathHelper urlPathHelper;
    @Value(value="${auth.resource}")
    private boolean resourceCheck;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object obj) {
        block11: {
            HttpServletRequest httpRequest = request;
            HttpServletResponse httpResponse = response;
            String contentPath = request.getContextPath();
            String requestMethod = (String)httpRequest.getAttribute("method");
            String requestUri = StringHelper.removePrefix((CharSequence)((String)httpRequest.getAttribute("url")), (CharSequence)contentPath);
            Optional<AuthModel> authDto = this.authService.getResources(requestUri).stream().filter(this.match(requestMethod, requestUri)).findFirst();
            if (authDto.isPresent()) {
                request.setAttribute("url", (Object)authDto.get().getResourceUrl());
            } else if (!this.resourceCheck) {
                request.setAttribute("url", (Object)requestUri);
            } else {
                log.error("Resource Not Found: " + requestUri + " - " + requestMethod);
                httpResponse.setStatus(404);
                this.sendNotFoundFail((ServletRequest)request, (ServletResponse)response);
                return false;
            }
            if (authDto.isPresent() && "0".equals(authDto.get().getResourceAuthType())) {
                return true;
            }
            String token = RequestUtil.getToken((HttpServletRequest)httpRequest);
            if (StringHelper.isNotBlank((CharSequence)token)) {
                try {
                    JwtInfos jwtInfos = JwtHelper.parseJwtAuth0((String)token, (String)"Token Issuer");
                    String userId = jwtInfos.getUserId();
                    if (!this.resourceCheck) {
                        return true;
                    }
                    if (authDto.isPresent() && "2".equals(authDto.get().getResourceAuthType())) {
                        RoleResourceModel roleResourceModel = this.authService.loadRoleResource(userId);
                        List<String> permsList = roleResourceModel.getPermissions();
                        boolean existed = permsList.contains(authDto.get().getResourceId());
                        if (!existed) {
                            httpResponse.setStatus(401);
                            this.sendUnauthorizedFail((ServletRequest)request, (ServletResponse)response);
                            return false;
                        }
                        return true;
                    }
                    break block11;
                }
                catch (ExpiredJwtException eje) {
                    this.sendExpiredJwt((ServletRequest)request, (ServletResponse)response);
                    return false;
                }
            }
            httpResponse.setStatus(403);
            this.sendForbiddenFail((ServletRequest)request, (ServletResponse)response);
            return false;
        }
        return true;
    }

    private Predicate<AuthModel> match(String method, String requestUri) {
        return res -> this.pathMatcher.match(res.getResourceUrl(), requestUri);
    }

    private boolean anyMatch(List<AuthModel> perms, String method, String requestUri) {
        return perms.stream().anyMatch(this.match(method, requestUri));
    }

    private void sendForbiddenFail(ServletRequest request, ServletResponse response) {
        ResponseUtil.response((HttpServletRequest)((HttpServletRequest)request), (HttpServletResponse)((HttpServletResponse)response), (HttpStatusCodeEnum)HttpStatusCodeEnum.FORBIDDEN, null);
    }

    private void sendNotFoundFail(ServletRequest request, ServletResponse response) {
        ResponseUtil.response((HttpServletRequest)((HttpServletRequest)request), (HttpServletResponse)((HttpServletResponse)response), (HttpStatusCodeEnum)HttpStatusCodeEnum.NOT_FOUND, null);
    }

    private void sendUnauthorizedFail(ServletRequest request, ServletResponse response) {
        ResponseUtil.response((HttpServletRequest)((HttpServletRequest)request), (HttpServletResponse)((HttpServletResponse)response), (ResponseInfo)BaseStatusEnum.UNAUTHORIZED.transform(), null);
    }

    private void sendExpiredJwt(ServletRequest request, ServletResponse response) {
        ResponseUtil.response((HttpServletRequest)((HttpServletRequest)request), (HttpServletResponse)((HttpServletResponse)response), (ResponseInfo)BaseStatusEnum.TOKEN_INVALID.transform(), null);
    }
}

