/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.core.helper;

import com.tongtech.tfw.backend.core.helper.CharsetHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.Objects;

public class TypeHelper {
    public static String castToString(Object object) {
        if (Objects.isNull(object)) {
            return null;
        }
        return object.toString();
    }

    public static String toStr(Object value, String defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static String toStr(Object value) {
        return TypeHelper.toStr(value, null);
    }

    public static Character toChar(Object value, Character defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        String valueStr = TypeHelper.toStr(value, null);
        return Character.valueOf(StringHelper.isEmpty(valueStr) ? defaultValue.charValue() : valueStr.charAt(0));
    }

    public static Character toChar(Object value) {
        return TypeHelper.toChar(value, null);
    }

    public static Byte toByte(Object value, Byte defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        String valueStr = TypeHelper.toStr(value, null);
        if (StringHelper.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Byte toByte(Object value) {
        return TypeHelper.toByte(value, null);
    }

    public static Short toShort(Object value, Short defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        String valueStr = TypeHelper.toStr(value, null);
        if (StringHelper.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return Short.parseShort(valueStr.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Short toShort(Object value) {
        return TypeHelper.toShort(value, null);
    }

    public static Number toNumber(Object value, Number defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        String valueStr = TypeHelper.toStr(value, null);
        if (StringHelper.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return NumberFormat.getInstance().parse(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Number toNumber(Object value) {
        return TypeHelper.toNumber(value, null);
    }

    public static Integer toInt(Object value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        String valueStr = TypeHelper.toStr(value, null);
        if (StringHelper.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(valueStr.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Integer toInt(Object value) {
        return TypeHelper.toInt(value, null);
    }

    public static Integer[] toIntArray(String str) {
        return TypeHelper.toIntArray(",", str);
    }

    public static Long[] toLongArray(String str) {
        return TypeHelper.toLongArray(",", str);
    }

    public static Integer[] toIntArray(String split, String str) {
        if (StringHelper.isEmpty(str)) {
            return new Integer[0];
        }
        String[] arr = str.split(split);
        Integer[] ints = new Integer[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            Integer v;
            ints[i] = v = TypeHelper.toInt(arr[i], 0);
        }
        return ints;
    }

    public static Long[] toLongArray(String split, String str) {
        if (StringHelper.isEmpty(str)) {
            return new Long[0];
        }
        String[] arr = str.split(split);
        Long[] longs = new Long[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            Long v;
            longs[i] = v = TypeHelper.toLong(arr[i], null);
        }
        return longs;
    }

    public static String[] toStrArray(String str) {
        return TypeHelper.toStrArray(",", str);
    }

    public static String[] toStrArray(String split, String str) {
        return str.split(split);
    }

    public static Long toLong(Object value, Long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        String valueStr = TypeHelper.toStr(value, null);
        if (StringHelper.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr.trim()).longValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Long toLong(Object value) {
        return TypeHelper.toLong(value, null);
    }

    public static Double toDouble(Object value, Double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        String valueStr = TypeHelper.toStr(value, null);
        if (StringHelper.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr.trim()).doubleValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Double toDouble(Object value) {
        return TypeHelper.toDouble(value, null);
    }

    public static Float toFloat(Object value, Float defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        String valueStr = TypeHelper.toStr(value, null);
        if (StringHelper.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Float.parseFloat(valueStr.trim()));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Float toFloat(Object value) {
        return TypeHelper.toFloat(value, null);
    }

    public static Boolean toBool(Object value, Boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String valueStr = TypeHelper.toStr(value, null);
        if (StringHelper.isEmpty(valueStr)) {
            return defaultValue;
        }
        switch (valueStr = valueStr.trim().toLowerCase()) {
            case "true": 
            case "ok": 
            case "yes": 
            case "1": {
                return true;
            }
            case "false": 
            case "no": 
            case "0": {
                return false;
            }
        }
        return defaultValue;
    }

    public static Boolean toBool(Object value) {
        return TypeHelper.toBool(value, null);
    }

    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object value, E defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (clazz.isAssignableFrom(value.getClass())) {
            Enum myE = (Enum)value;
            return (E)myE;
        }
        String valueStr = TypeHelper.toStr(value, null);
        if (StringHelper.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(clazz, valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object value) {
        return TypeHelper.toEnum(clazz, value, null);
    }

    public static BigInteger toBigInteger(Object value, BigInteger defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Long) {
            return BigInteger.valueOf((Long)value);
        }
        String valueStr = TypeHelper.toStr(value, null);
        if (StringHelper.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigInteger(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static BigInteger toBigInteger(Object value) {
        return TypeHelper.toBigInteger(value, null);
    }

    public static BigDecimal toBigDecimal(Object value, BigDecimal defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Double) {
            return BigDecimal.valueOf((Double)value);
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        String valueStr = TypeHelper.toStr(value, null);
        if (StringHelper.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static BigDecimal toBigDecimal(Object value) {
        return TypeHelper.toBigDecimal(value, null);
    }

    public static String utf8Str(Object obj) {
        return TypeHelper.str(obj, CharsetHelper.CHARSET_UTF_8);
    }

    public static String str(Object obj, String charsetName) {
        return TypeHelper.str(obj, Charset.forName(charsetName));
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[] || obj instanceof Byte[]) {
            return TypeHelper.str(obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return TypeHelper.str((ByteBuffer)obj, charset);
        }
        return obj.toString();
    }

    public static String str(byte[] bytes, String charset) {
        return TypeHelper.str(bytes, StringHelper.isEmpty(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        return TypeHelper.str(data, Charset.forName(charset));
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static byte[] hexToByte(String hex) throws IllegalArgumentException {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        char[] arr = hex.toCharArray();
        byte[] b = new byte[hex.length() / 2];
        int i = 0;
        int j = 0;
        int l = hex.length();
        while (i < l) {
            String swap = "" + arr[i++] + arr[i];
            int byteint = Integer.parseInt(swap, 16) & 0xFF;
            b[j] = new Integer(byteint).byteValue();
            ++i;
            ++j;
        }
        return b;
    }

    public static String byteToHex(byte[] b) {
        if (b == null) {
            throw new IllegalArgumentException("Argument b ( byte array ) is null! ");
        }
        StringBuilder hs = new StringBuilder();
        String stmp = "";
        for (byte value : b) {
            stmp = Integer.toHexString(value & 0xFF);
            if (stmp.length() == 1) {
                hs.append("0").append(stmp);
                continue;
            }
            hs.append(stmp);
        }
        return hs.toString().toLowerCase();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(TypeHelper.charToByte(hexChars[pos]) << 4 | TypeHelper.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    public static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static String digitUppercase(double n) {
        String[] fraction = new String[]{"\u89d2", "\u5206"};
        String[] digit = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
        String[][] unit = new String[][]{{"\u5143", "\u4e07", "\u4ebf"}, {"", "\u62fe", "\u4f70", "\u4edf"}};
        String head = n < 0.0 ? "\u8d1f" : "";
        n = Math.abs(n);
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < fraction.length; ++i) {
            s.append((digit[(int)(Math.floor(n * 10.0 * Math.pow(10.0, i)) % 10.0)] + fraction[i]).replaceAll("(\u96f6.)+", ""));
        }
        if (s.length() < 1) {
            s = new StringBuilder("\u6574");
        }
        int integerPart = (int)Math.floor(n);
        for (int i = 0; i < unit[0].length && integerPart > 0; ++i) {
            StringBuilder p = new StringBuilder();
            for (int j = 0; j < unit[1].length && n > 0.0; ++j) {
                p.insert(0, digit[integerPart % 10] + unit[1][j]);
                integerPart /= 10;
            }
            s.insert(0, p.toString().replaceAll("(\u96f6.)*\u96f6$", "").replaceAll("^$", "\u96f6") + unit[0][i]);
        }
        return head + s.toString().replaceAll("(\u96f6.)*\u96f6\u5143", "\u5143").replaceFirst("(\u96f6.)+", "").replaceAll("(\u96f6.)+", "\u96f6").replaceAll("^\u6574$", "\u96f6\u5143\u6574");
    }
}

