/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.monitor.core.instrument;

import com.tongweb.commons.monitor.core.instrument.Clock;
import com.tongweb.commons.monitor.core.instrument.Measurement;
import com.tongweb.commons.monitor.core.instrument.Meter;
import com.tongweb.commons.monitor.core.instrument.MeterRegistry;
import com.tongweb.commons.monitor.core.instrument.Statistic;
import com.tongweb.commons.monitor.core.instrument.Tag;
import com.tongweb.commons.monitor.core.instrument.Tags;
import com.tongweb.commons.monitor.core.instrument.distribution.CountAtBucket;
import com.tongweb.commons.monitor.core.instrument.distribution.DistributionStatisticConfig;
import com.tongweb.commons.monitor.core.instrument.distribution.HistogramSupport;
import com.tongweb.commons.monitor.core.instrument.distribution.ValueAtPercentile;
import com.tongweb.commons.monitor.core.instrument.distribution.pause.PauseDetector;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public interface Timer
extends Meter,
HistogramSupport {
    public static Sample start() {
        return Timer.start(Clock.SYSTEM);
    }

    public static Sample start(MeterRegistry registry) {
        return Timer.start(registry.config().clock());
    }

    public static Sample start(Clock clock) {
        return new Sample(clock);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public void record(long var1, TimeUnit var3);

    default public void record(Duration duration) {
        this.record(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public <T> T record(Supplier<T> var1);

    public <T> T recordCallable(Callable<T> var1) throws Exception;

    public void record(Runnable var1);

    default public Runnable wrap(Runnable f) {
        return () -> this.record(f);
    }

    default public <T> Callable<T> wrap(Callable<T> f) {
        return () -> this.recordCallable(f);
    }

    default public <T> Supplier<T> wrap(Supplier<T> f) {
        return () -> this.record(f);
    }

    public long count();

    public double totalTime(TimeUnit var1);

    default public double mean(TimeUnit unit) {
        long count = this.count();
        return count == 0L ? 0.0 : this.totalTime(unit) / (double)count;
    }

    public double max(TimeUnit var1);

    @Override
    default public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.count(), Statistic.COUNT), new Measurement(() -> this.totalTime(this.baseTimeUnit()), Statistic.TOTAL_TIME), new Measurement(() -> this.max(this.baseTimeUnit()), Statistic.MAX));
    }

    @Deprecated
    default public double histogramCountAtValue(long valueNanos) {
        for (CountAtBucket countAtBucket : this.takeSnapshot().histogramCounts()) {
            if ((long)countAtBucket.bucket(TimeUnit.NANOSECONDS) != valueNanos) continue;
            return countAtBucket.count();
        }
        return Double.NaN;
    }

    @Deprecated
    default public double percentile(double percentile, TimeUnit unit) {
        for (ValueAtPercentile valueAtPercentile : this.takeSnapshot().percentileValues()) {
            if (valueAtPercentile.percentile() != percentile) continue;
            return valueAtPercentile.value(unit);
        }
        return Double.NaN;
    }

    public TimeUnit baseTimeUnit();

    public static class Builder {
        private final String name;
        private Tags tags = Tags.empty();
        private final DistributionStatisticConfig.Builder distributionConfigBuilder;
        private String description;
        private PauseDetector pauseDetector;

        private Builder(String name) {
            this.name = name;
            this.distributionConfigBuilder = new DistributionStatisticConfig.Builder();
            this.minimumExpectedValue(Duration.ofMillis(1L));
            this.maximumExpectedValue(Duration.ofSeconds(30L));
        }

        public Builder tags(String ... tags) {
            return this.tags(Tags.of(tags));
        }

        public Builder tags(Iterable<Tag> tags) {
            this.tags = this.tags.and(tags);
            return this;
        }

        public Builder tag(String key, String value) {
            this.tags = this.tags.and(key, value);
            return this;
        }

        public Builder publishPercentiles(double ... percentiles) {
            this.distributionConfigBuilder.percentiles(percentiles);
            return this;
        }

        public Builder percentilePrecision(Integer digitsOfPrecision) {
            this.distributionConfigBuilder.percentilePrecision(digitsOfPrecision);
            return this;
        }

        public Builder publishPercentileHistogram() {
            return this.publishPercentileHistogram(true);
        }

        public Builder publishPercentileHistogram(Boolean enabled) {
            this.distributionConfigBuilder.percentilesHistogram(enabled);
            return this;
        }

        @Deprecated
        public Builder sla(Duration ... sla) {
            return this.serviceLevelObjectives(sla);
        }

        public Builder serviceLevelObjectives(Duration ... slos) {
            if (slos != null) {
                this.distributionConfigBuilder.serviceLevelObjectives(Arrays.stream(slos).mapToDouble(Duration::toNanos).toArray());
            }
            return this;
        }

        public Builder minimumExpectedValue(Duration min) {
            if (min != null) {
                this.distributionConfigBuilder.minimumExpectedValue(Double.valueOf(min.toNanos()));
            }
            return this;
        }

        public Builder maximumExpectedValue(Duration max) {
            if (max != null) {
                this.distributionConfigBuilder.maximumExpectedValue(Double.valueOf(max.toNanos()));
            }
            return this;
        }

        public Builder distributionStatisticExpiry(Duration expiry) {
            this.distributionConfigBuilder.expiry(expiry);
            return this;
        }

        public Builder distributionStatisticBufferLength(Integer bufferLength) {
            this.distributionConfigBuilder.bufferLength(bufferLength);
            return this;
        }

        public Builder pauseDetector(PauseDetector pauseDetector) {
            this.pauseDetector = pauseDetector;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Timer register(MeterRegistry registry) {
            return registry.timer(new Meter.Id(this.name, this.tags, null, this.description, Meter.Type.TIMER), this.distributionConfigBuilder.build(), this.pauseDetector == null ? registry.config().pauseDetector() : this.pauseDetector);
        }
    }

    public static class Sample {
        private Tags tags = Tags.empty();
        private final long startTime;
        private final Clock clock;

        Sample(Clock clock) {
            this.clock = clock;
            this.startTime = clock.monotonicTime();
        }

        public long stop(Timer timer) {
            long durationNs = this.clock.monotonicTime() - this.startTime;
            timer.record(durationNs, TimeUnit.NANOSECONDS);
            return durationNs;
        }

        public long stop(MeterRegistry registry, Builder timerBuilder) {
            return this.stop(timerBuilder.tags(this.tags).register(registry));
        }

        public Sample tags(String ... tags) {
            return this.tags(Tags.of(tags));
        }

        public Sample tags(Iterable<Tag> tags) {
            this.tags = this.tags.and(tags);
            return this;
        }
    }
}

