/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.monitor.core.instrument.internal;

import com.tongweb.commons.monitor.core.instrument.Clock;
import com.tongweb.commons.monitor.core.instrument.Meter;
import com.tongweb.commons.monitor.core.instrument.distribution.CountAtBucket;
import com.tongweb.commons.monitor.core.instrument.distribution.DistributionStatisticConfig;
import com.tongweb.commons.monitor.core.instrument.distribution.HistogramSnapshot;
import com.tongweb.commons.monitor.core.instrument.internal.DefaultLongTaskTimer;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class CumulativeHistogramLongTaskTimer
extends DefaultLongTaskTimer {
    private CountAtBucket[] lastSnapshot;

    public CumulativeHistogramLongTaskTimer(Meter.Id id, Clock clock, TimeUnit baseTimeUnit, DistributionStatisticConfig distributionStatisticConfig) {
        super(id, clock, baseTimeUnit, distributionStatisticConfig, true);
    }

    @Override
    public HistogramSnapshot takeSnapshot() {
        HistogramSnapshot snapshot = super.takeSnapshot();
        AtomicInteger i = new AtomicInteger(0);
        snapshot = new HistogramSnapshot(snapshot.count(), snapshot.total(), snapshot.max(), snapshot.percentileValues(), (CountAtBucket[])Arrays.stream(snapshot.histogramCounts()).map(countAtBucket -> this.lastSnapshot == null ? countAtBucket : new CountAtBucket(countAtBucket.bucket(), countAtBucket.count() + this.lastSnapshot[i.getAndIncrement()].count())).toArray(CountAtBucket[]::new), snapshot::outputSummary);
        this.lastSnapshot = snapshot.histogramCounts();
        return snapshot;
    }
}

