/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.starter;

import com.tongweb.container.Container;
import com.tongweb.container.Manager;
import com.tongweb.container.SessionIdGenerator;
import com.tongweb.container.WebResource;
import com.tongweb.container.Wrapper;
import com.tongweb.container.core.StandardContext;
import com.tongweb.container.core.StandardWrapper;
import com.tongweb.container.session.ManagerBase;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.springboot.loader.JarFile;
import com.tongweb.springboot.starter.LazySessionIdGenerator;
import com.tongweb.springboot.starter.TongWebEmbedStandardRoot;
import com.tongweb.springboot.starter.TongWebStarter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class TongWebEmbedContext
extends StandardContext {
    private static final Log log = LogFactory.getLog(TongWebEmbedContext.class);
    private TongWebStarter starter;
    private final boolean overrideLoadOnStart;
    private TongWebEmbedStandardRoot standardRoot;
    private List<WebResource> webResources = new ArrayList<WebResource>();
    private JarFile rootJar;
    private Set<String> resourceJars = new HashSet<String>();
    private Map<String, byte[]> jarEntryMap = new ConcurrentHashMap<String, byte[]>(5000);

    TongWebEmbedContext() {
        this.overrideLoadOnStart = ReflectionUtils.findMethod(StandardContext.class, (String)"loadOnStartup", (Class[])new Class[]{Container[].class}).getReturnType() == Boolean.TYPE;
    }

    public boolean loadOnStartup(Container[] children) {
        if (this.overrideLoadOnStart) {
            return true;
        }
        return super.loadOnStartup(children);
    }

    public void setManager(Manager manager) {
        if (manager instanceof ManagerBase) {
            manager.setSessionIdGenerator((SessionIdGenerator)new LazySessionIdGenerator());
        }
        super.setManager(manager);
    }

    void deferredLoadOnStartup() {
        this.doWithThreadContextClassLoader(this.getLoader().getClassLoader(), () -> this.getLoadOnStartupWrappers(this.findChildren()).forEach(this::load));
    }

    private void load(Wrapper wrapper) {
        try {
            wrapper.load();
        }
        catch (ServletException ex) {
            String message = sm.getString("standardContext.loadOnStartup.loadException", new Object[]{this.getName(), wrapper.getName()});
            if (this.getComputedFailCtxIfServletStartFails()) {
                throw new WebServerException(message, (Throwable)ex);
            }
            this.getLogger().error((Object)message, StandardWrapper.getRootCause((ServletException)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWithThreadContextClassLoader(ClassLoader classLoader, Runnable code) {
        ClassLoader existingLoader = classLoader != null ? ClassUtils.overrideThreadContextClassLoader((ClassLoader)classLoader) : null;
        try {
            code.run();
        }
        finally {
            if (existingLoader != null) {
                ClassUtils.overrideThreadContextClassLoader((ClassLoader)existingLoader);
            }
        }
    }

    private Stream<Wrapper> getLoadOnStartupWrappers(Container[] children) {
        TreeMap<Integer, List> grouped = new TreeMap<Integer, List>();
        for (Container child : children) {
            Wrapper wrapper = (Wrapper)child;
            int order = wrapper.getLoadOnStartup();
            if (order < 0) continue;
            grouped.computeIfAbsent(order, o -> new ArrayList()).add(wrapper);
        }
        return grouped.values().stream().flatMap(Collection::stream);
    }

    public void setStarter(TongWebStarter starter) {
        this.starter = starter;
    }

    public TongWebStarter getStarter() {
        return this.starter;
    }
}

