/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.common.config;

import com.tongtech.tfw.backend.core.helper.datetime.DatetimeHelper;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;

public class ParameterConverters
implements GenericConverter {
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        HashSet<GenericConverter.ConvertiblePair> pairs = new HashSet<GenericConverter.ConvertiblePair>();
        pairs.add(new GenericConverter.ConvertiblePair(String.class, LocalDateTime.class));
        pairs.add(new GenericConverter.ConvertiblePair(String.class, LocalDate.class));
        pairs.add(new GenericConverter.ConvertiblePair(String.class, Date.class));
        return pairs;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null || sourceType == null || targetType == null) {
            return null;
        }
        if (sourceType.getType().equals(String.class) && targetType.getType().equals(LocalDateTime.class)) {
            return DatetimeHelper.parse((CharSequence)((String)source));
        }
        if (sourceType.getType().equals(String.class) && targetType.getType().equals(LocalDate.class)) {
            return DatetimeHelper.parseDate((CharSequence)((String)source));
        }
        if (sourceType.getType().equals(String.class) && targetType.getType().equals(Date.class)) {
            String input = (String)source;
            try {
                if (input.contains("-")) {
                    SimpleDateFormat formatter = input.contains(":") ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd");
                    return formatter.parse(input);
                }
                if (input.matches("^\\d+$")) {
                    Long lDate = new Long(input);
                    return new Date(lDate);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("parser %s to Date fail", input));
            }
        }
        return null;
    }
}

