/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.core;

import com.tongweb.container.Context;
import com.tongweb.container.LifecycleEvent;
import com.tongweb.container.LifecycleListener;
import com.tongweb.container.core.ContextNamingInfoListener;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.web.util.file.ConfigurationSource;
import com.tongweb.web.util.res.StringManager;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class PropertiesRoleMappingListener
implements LifecycleListener {
    private static final String WEBAPP_PROTOCOL = "webapp:";
    private static final Log log = LogFactory.getLog(PropertiesRoleMappingListener.class);
    private static final StringManager sm = StringManager.getManager(ContextNamingInfoListener.class);
    private String roleMappingFile = "webapp:/WEB-INF/role-mapping.properties";
    private String keyPrefix;

    public void setRoleMappingFile(String roleMappingFile) {
        Objects.requireNonNull(roleMappingFile, sm.getString("propertiesRoleMappingListener.roleMappingFileNull"));
        if (roleMappingFile.isEmpty()) {
            throw new IllegalArgumentException(sm.getString("propertiesRoleMappingListener.roleMappingFileEmpty"));
        }
        this.roleMappingFile = roleMappingFile;
    }

    public String getRoleMappingFile() {
        return this.roleMappingFile;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType().equals("configure_start")) {
            if (!(event.getLifecycle() instanceof Context)) {
                log.warn(sm.getString("listener.notContext", event.getLifecycle().getClass().getSimpleName()));
                return;
            }
            Properties props = new Properties();
            Context context = (Context)event.getLifecycle();
            try {
                ConfigurationSource.Resource resource = context.findConfigFileResource(this.roleMappingFile);
                Object object = null;
                try {
                    props.load(resource.getInputStream());
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (resource != null) {
                        if (object != null) {
                            try {
                                resource.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            resource.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(sm.getString("propertiesRoleMappingListener.roleMappingFileFail", this.roleMappingFile), e);
            }
            int linkCount = 0;
            for (Map.Entry entry : props.entrySet()) {
                String role = (String)entry.getKey();
                if (this.keyPrefix != null) {
                    if (!role.startsWith(this.keyPrefix)) continue;
                    role = role.substring(this.keyPrefix.length());
                }
                String link = (String)entry.getValue();
                if (log.isTraceEnabled()) {
                    log.trace(sm.getString("propertiesRoleMappingListener.linkedRole", role, link));
                }
                context.addRoleMapping(role, link);
                ++linkCount;
            }
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("propertiesRoleMappingListener.linkedRoleCount", linkCount));
            }
        }
    }
}

