# 数据库
    DELETE from t_sys_rule where rule_id = '3c66aef141bc47d48e4214f08a057b72';

    CREATE INDEX idx_job_code ON t_job_statistics(CODE);
    CREATE INDEX idx_job_status ON t_job_statistics(status);
    CREATE INDEX idx_job_dhzy_zykssj ON t_job_statistics(DHZY_ZYKSSJ);
    CREATE INDEX idx_job_dhzy_zyjssj ON t_job_statistics(DHZY_ZYJSSJ);
    
    CREATE INDEX idx_org_org_code ON t_sys_org(org_code);
    CREATE INDEX idx_org_org_id ON t_sys_org(org_id);
    CREATE INDEX idx_org_parent_id ON t_sys_org(parent_id);
    CREATE INDEX idx_org_tree_level ON t_sys_org(tree_level);
    
    
    
    -- 为 t_safe_risk_source 表的 Inherent_level_id 字段添加索引
    CREATE INDEX idx_inherent_level_id ON t_safe_risk_source (Inherent_level_id);
    
    -- 为 t_safe_risk_source 表的 real_level_id 字段添加索引
    CREATE INDEX idx_real_level_id ON t_safe_risk_source (real_level_id);
    
    -- 为 t_safe_risk_source 表的 org_id 字段添加索引
    CREATE INDEX idx_org_id ON t_safe_risk_source (org_id);
    
    -- 为 t_safe_risk_source 表的 status 字段添加索引
    CREATE INDEX idx_status ON t_safe_risk_source (status);
    
    -- 为 t_sys_dict_data 表的 dict_data_id 字段添加索引
    CREATE INDEX idx_dict_data_id ON t_sys_dict_data (dict_data_id); 

    CREATE OR REPLACE VIEW act_id_group AS
    SELECT
    NULL AS REV_,
    CONCAT(r.tree_level, '-', r.role_id) AS ID_,
    CASE
    WHEN r.tree_level = 1 THEN CONCAT('总公司', '-', r.role_name)
    WHEN r.tree_level = 2 THEN CONCAT('区域公司', '-', r.role_name)
    WHEN r.tree_level = 3 THEN CONCAT('粮库公司', '-', r.role_name)
    ELSE r.role_name
    END AS NAME_,
    r.tree_level AS TYPE_
    FROM
    t_sys_role r
    WHERE
    r.status = 0 AND r.tree_level IS NOT NULL
    ORDER BY
    r.tree_level;   

    CREATE OR REPLACE VIEW act_id_user AS
    SELECT
    su.user_id AS ID_,
    NULL AS REV_,
    su.user_name AS FIRST_,
    NULL AS LAST_,
    su.email AS EMAIL_,
    su.login_pwd AS PWD_,
    NULL AS PICTURE_ID_
    FROM
    t_sys_user su;

    CREATE OR REPLACE VIEW act_id_membership AS
    SELECT
    u.user_id AS USER_ID_,
    CONCAT(u.org_id, '-', ur.role_id) AS GROUP_ID_
    FROM
    t_sys_user_role ur
    JOIN
    t_sys_user u
    ON
    ur.user_id = u.user_id
    WHERE
    u.status = 0;





  



# 模型需要重新部署



# 验证数据库完成性 

1 查询表数量 309  
2 视图 
3 流程相关的表 数量   79 
SELECT COUNT(*)
FROM INFORMATION_SCHEMA.TABLES
 WHERE TABLE_SCHEMA = 'zlmy'  
 AND TABLE_NAME LIKE 'act%';  



SELECT  TABLE_NAME  FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = 'zlmy'     AND TABLE_NAME LIKE 'act%' order by TABLE_NAME  ;


SELECT TABLE_NAME AS view_name  FROM information_schema.views  WHERE TABLE_SCHEMA = 'zlmy';
+-------------------+
| view_name         |
+-------------------+
| act_id_group      |
| act_id_membership |
| act_id_user       |
+-------------------+

 


   
