package com.testor.common.exception;

import com.alibaba.excel.exception.ExcelAnalysisException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * @author rsq
 * @program zlmy_boot
 * @return
 **/
@Order(Ordered.HIGHEST_PRECEDENCE)
@RestControllerAdvice
public class CommonExceptionHandler {

    private static final Logger logger = LoggerFactory.getLogger(CommonExceptionHandler.class);
    /**
     * 处理自定义的业务异常
     * @param e
     * @return
     */
    @ExceptionHandler(value = CommonException.class)
    public BaseResponse<?> commonExceptionHandler(CommonException e) {
        BaseResponse response = new BaseResponse<>();
        logger.error("发生业务异常！原因是：{}", e.getMsg());
        response.setCode(400);
        response.setData(e.getMsg());
        return response;
    }

    @ExceptionHandler(value = ExcelAnalysisException.class)
    public BaseResponse<?> ExcelAnalysisExceptionHandler(ExcelAnalysisException e) {
        BaseResponse response = new BaseResponse<>();
        logger.error("发生业务异常！原因是：{}", e.getMessage());
        response.setCode(400);
        response.setData(e.getMessage());
        return response;
    }

    @ExceptionHandler(value = Exception.class)
    public BaseResponse<?> ExceptionHandler(CommonException e) {
        BaseResponse response = new BaseResponse<>();
        logger.error("发生业务异常！原因是：{}", e.getMsg());
        response.setCode(400);
        response.setData(e.getMsg());
        return response;
    }

    @ExceptionHandler(value = TokenExpiredException.class)
    public BaseResponse<?> TokenExceptionHandler(TokenExpiredException e) {
        BaseResponse response = new BaseResponse<>();
        logger.error("发生业务异常！原因是：{}", e.getMessage());
        response.setCode(400);
        response.setData("登录信息已过期，请重新登录");
        return response;
    }



    @ExceptionHandler(value = NullPointerException.class)
    public BaseResponse<?> NullPointerExceptionHandler(NullPointerException e) {
        BaseResponse response = new BaseResponse<>();
        logger.error("发生业务异常！原因是：{}", e.getMessage());
        response.setCode(400);
        response.setData("登录信息已过期，请重新登录");
        return response;
    }



}
