package com.testor.common.util.cron;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * 任务频率属性
 *  组装cron表达式 所需字段
 * @author testor-framework
 * @date 2022-08-04 11:07:50
 */
@Data
public class FrequencyDTO implements Serializable
{

  @ApiModelProperty(value = "任务频次key(关联字典表key)")
  private String frequencyKey;

  @ApiModelProperty(value = "秒（0-60）" , example = "0")
  private Integer second;

  @ApiModelProperty(value = "分钟（0-60）" , example = "0")
  private Integer minute;

  @ApiModelProperty(value = "时间(12:32:33)")
  private String time;

  @ApiModelProperty(value = "日期(日期,不包含时间)")
  private String date;

  @ApiModelProperty(value = "数字天(如一个月的第几天(1-31,0表示最后一天)，周的周几(1-7))" , example = "0")
  private Integer dayNum;

  @ApiModelProperty(value = "数字月(如年的第几个月，季度的第几个月)" , example = "0")
  private Integer monthNum;

  @ApiModelProperty(value = "提前或延后时长（小时，提前：负值； 延后：正值）")
  private Long advanceHour;

}
