package com.testor.config;

import com.tongtech.tfw.backend.core.constants.FrameworkConstants;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * ExecutorConfig
 *
 * <p>//ThreadPoolTaskExecutor
 *
 * @author Created by ivan on 2020/6/15 .
 * @version 1.0
 */
@Configuration
@EnableAsync
@Slf4j
public class ExecutorConfig {
  @Value("${tong.async.executor.thread.core_pool_size:5}")
  private int corePoolSize;

  @Value("${tong.async.executor.thread.max_pool_size:5}")
  private int maxPoolSize;

  @Value("${tong.async.executor.thread.queue_capacity:999}")
  private int queueCapacity;

  @Value("${tong.async.executor.thread.name.prefix:tong-async-}")
  private String namePrefix;

  @Bean(name = FrameworkConstants.EXECUTOR_NAME)
  public Executor asyncServiceExecutor() {
    ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
    // 配置核心线程数
    executor.setCorePoolSize(corePoolSize);
    // 配置最大线程数
    executor.setMaxPoolSize(maxPoolSize);
    // 配置队列大小
    executor.setQueueCapacity(queueCapacity);
    // 配置线程池中的线程的名称前缀
    executor.setThreadNamePrefix(namePrefix);
    // rejection-policy：当pool已经达到max size的时候，如何处理新任务
    // CALLER_RUNS：不在新线程中执行任务，而是有调用者所在的线程来执行
    executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
    // 执行初始化
    executor.initialize();
    return executor;
  }
}
