package com.testor.ddd.safetyControl.application.service.riskMap;

import com.testor.ddd.safetyControl.interfaces.model.dto.riskMap.TSafeRiskMapDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskMap.TSafeRiskMapDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskMap.TSafeRiskMapVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;

import java.util.List;

public interface RiskMapManageService {
    /**
     * 编辑空间
     * @param RiskMapOrgDto
     * @return
     */
    BaseResponse editRiskMap(TSafeRiskMapDTO RiskMapOrgDto) throws RuntimeException;

    BaseResponseList<TSafeRiskMapVO> listByPage(TSafeRiskMapDTOParam param);

    TSafeRiskMapDTO findById(String id);

    BaseResponse deleteById(String id) throws RuntimeException;

    TSafeRiskMapVO findDetailById(String id);

    /**
     * 列表不分页
     * @param param
     * @return
     */
    List<TSafeRiskMapDTO> listAll(TSafeRiskMapDTOParam param);

    /**
     * 检测 名称 是否都唯一
     * @return true - 唯一； false - 不唯一
     */
    boolean checkUniqueness(String orgId, String sourceId, String name);

}
