package com.testor.ddd.safetyControl.domain.riskPoint.entity;

import com.testor.ddd.safetyControl.interfaces.model.dto.riskPoint.TSafeRiskPointDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskPoint.TSafeRiskPointDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskPoint.TSafeRiskPointVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;

import java.util.List;

/**
 *
 * 连接持久化的接口，具体实现类为 infrastructure.repository.impl
 *
 */
public interface TSafeRiskPointRepo {

    TSafeRiskPointDTO insert(TSafeRiskPointDTO riskPointDTO);

    TSafeRiskPointDTO updateById(TSafeRiskPointDTO riskPointDTO);

    /**
     * 分页查询
     * @param param
     * @return
     */
    BaseResponseList<TSafeRiskPointVO> listPage(TSafeRiskPointDTOParam param);

    TSafeRiskPointDTO findById(String id);

    boolean deleteById(String id);

    List<TSafeRiskPointDTO> listAllEntity(TSafeRiskPointDTOParam param);

    boolean saveBatch(List<TSafeRiskPointDTO> riskPointDTOList);

    /**
     * 根据id查看详情
     * @param id
     * @return
     */
    TSafeRiskPointVO findDetailById(String id);

    /**
     *
     * @param type 1-设备; 2-空间(作业区域)；  3-空间(车间场所)；
     * @param bizId type=1-设备id; 2-空间(作业区域)id；  3-空间(车间场所)id；
     * @return
     */
    boolean deleteBySpaceOrEquipment(Integer type, String bizId);

    TSafeRiskPointDTO findBySource(String sourceId);

    /**
     * 检测 名称、编码 是否都唯一
     * @return true - 唯一； false - 不唯一
     */
    List<TSafeRiskPointDTO> checkUniqueness(String orgId, String pointId, String name);

}
