package com.testor.ddd.safetyControl.infrastructure.repository.equipment.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.ddd.safetyControl.infrastructure.repository.equipment.entity.TSafeEquipmentDO;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.equipment.TSafeEquipmentVO;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 空间设备Mapper接口
 *
 * @author testor-framework
 * @date 2022-06-27 16:56:19
 */
public interface TSafeEquipmentDao extends SuperDao<TSafeEquipmentDO>
{
    /**
     * 车间场所分页查询
     * @param param
     * @return
     */
    IPage<TSafeEquipmentVO> listPage(Page<TSafeEquipmentVO> page, @Param("query") TSafeEquipmentDTOParam param);

    TSafeEquipmentVO findDetailById(@Param("id") String id);

    Integer countEquipment(@Param("query") TSafeEquipmentDTOParam param);

    Integer replaceCode(@Param("typeId") String typeId, @Param("oldCode") String oldCode, @Param("newCode") String newCode);

    /**
     * 设备列表 （安全风险 拉下数据）
     * @param param
     * @return
     */
    List<TSafeEquipmentVO> listForRisk(@Param("query") TSafeEquipmentDTOParam param);

}
