package com.testor.ddd.safetyControl.infrastructure.repository.lecls.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.testor.ddd.safetyControl.domain.lecls.entity.TSafeRiskRealLevelRelationRepo;
import com.testor.ddd.safetyControl.infrastructure.repository.lecls.dao.TSafeRiskRealLevelRelationDao;
import com.testor.ddd.safetyControl.infrastructure.repository.lecls.entity.TSafeRiskRealLevelRelationDO;
import com.testor.ddd.safetyControl.interfaces.model.dto.lecls.*;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 危险源Service业务层处理
 * 
 * @author testor-framework
 * @date 2022-07-11 10:00:17
 */
@Service
public class TSafeRiskRealLevelRelationServiceImpl extends SuperServiceImpl<TSafeRiskRealLevelRelationDao, TSafeRiskRealLevelRelationDO>
        implements TSafeRiskRealLevelRelationRepo
{
    @Autowired(required = false)
    private TSafeRiskRealLevelRelationDao tSafeRiskRealLevelRelationDao;

    public List<TSafeRiskRealLevelRelationDTO> findByRealLevel(String realLevel){
        LambdaQueryWrapper<TSafeRiskRealLevelRelationDO> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TSafeRiskRealLevelRelationDO::getStatus, BizConstants.STATUS_ENABLE)
                .eq(TSafeRiskRealLevelRelationDO::getRealLevel, realLevel);
        List<TSafeRiskRealLevelRelationDO> levelRelationDOList = tSafeRiskRealLevelRelationDao.selectList(queryWrapper);

        List<TSafeRiskRealLevelRelationDTO> levelRelationDTOList = BeanHelper.listToList(levelRelationDOList, TSafeRiskRealLevelRelationDTO.class);
        return levelRelationDTOList;
    }
}

