package com.testor.ddd.safetyControl.infrastructure.repository.riskMap.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 风险地图元素对象 t_safe_risk_map_element
 * 
 * @author testor-framework
 * @date 2022-10-05 15:18:07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_risk_map_element")
@ApiModel(value = "TSafeRiskMapElement对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeRiskMapElementDO extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  @TableId(value = "id",type = IdType.ASSIGN_UUID)
  private String id;
/**
 * 风险地图id
 */
  @ApiModelProperty(value = "风险地图id")

  @TableField("map_id")
  private String mapId;
/**
 * 空间id
 */
  @ApiModelProperty(value = "空间id")

  @TableField("space_id")
  private String spaceId;
/**
 * 现实风险等级(关联字典表id)
 */
  @ApiModelProperty(value = "现实风险等级(关联字典表id)")

  @TableField("real_level_id")
  private String realLevelId;
/**
 * 固有风险等级(关联字典表id)
 */
  @ApiModelProperty(value = "固有风险等级(关联字典表id)")

  @TableField("inherent_level_id")
  private String inherentLevelId;
/**
 * 责任部门
 */
  @ApiModelProperty(value = "责任部门")

  @TableField("department_id")
  private String departmentId;
/**
 * 责任人
 */
  @ApiModelProperty(value = "责任人")

  @TableField("user_id")
  private String userId;
/**
 * 地图坐标信息
 */
  @ApiModelProperty(value = "地图坐标信息")
  @TableField("map_json")
  private String mapJson;
/**
 * 固有风险等级编号
 */
  @ApiModelProperty(value = "固有风险等级编号")

  @TableField("inherent_level_code")
  private String inherentLevelCode;
/**
 * 现实风险等级编号
 */
  @ApiModelProperty(value = "现实风险等级编号")

  @TableField("real_level_code")
  private String realLevelCode;

  /**
   * 风险类型(1-现实风险；2-固有风险)
   */
  @ApiModelProperty(value = "风险类型(1-现实风险；2-固有风险)")
  @TableField("level_type")
  private String levelType;

  public static final String ID ="id";
  public static final String MAP_ID ="map_id";
  public static final String SPACE_ID ="space_id";
  public static final String REAL_LEVEL_ID ="real_level_id";
  public static final String INHERENT_LEVEL_ID ="inherent_level_id";
  public static final String DEPARTMENT_ID ="department_id";
  public static final String USER_ID ="user_id";
  public static final String MAP_JSON ="map_json";
  public static final String INHERENT_LEVEL_CODE ="inherent_level_code";
  public static final String REAL_LEVEL_CODE ="real_level_code";
  public static final String LEVEL_TYPE ="level_type";

}
