package com.testor.ddd.safetyControl.interfaces.model.vo.riskSource;

import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 
 * @author sj
 * @date 2022-06-27 16:56:21
 */
@Data
public class RiskSourceReportVO extends SuperModel
{

  /**
   * id
   */
  @ApiModelProperty(value = "id")
  private String id;

  @ApiModelProperty(value = "组织结构完整路径(到部门)")
  private String orgAllPath;
  /**
   * 组织机构id
   */
  @ApiModelProperty(value = "组织机构id")
  private String orgId;

  @ApiModelProperty(value = "组织机构")
  private String orgName;

  @ApiModelProperty(value = "部门id")
  private String departmentId;

  @ApiModelProperty(value = "部门")
  private String departmentName;

  @ApiModelProperty(value = "区域公司id")
  private String regionOrgId;

  @ApiModelProperty(value = "区域公司名称")
  private String regionOrgName;

  @ApiModelProperty(value = "基层单位id")
  private String basicOrgId;

  @ApiModelProperty(value = "基层单位名称")
  private String basicOrgName;

  /**
   * 名称
   */
  @ApiModelProperty(value = "名称")
  private String name;
  /**
   * 编码
   */
  @ApiModelProperty(value = "编码")
  private String code;
  /**
   * 工序工艺
   */
  @ApiModelProperty(value = "工序工艺")
  private String processes;
  /**
   * 可能导致的后果(关联字典表id)
   */
  @ApiModelProperty(value = "可能导致的后果(关联字典表id)")
  private String consequenceId;
  /**
   * 可能导致的后果
   */
  @ApiModelProperty(value = "可能导致的后果")
  private String consequenceName;
  /**
   * 危险源类型(关联字典表id)
   */
  @ApiModelProperty(value = "危险源类型(关联字典表id)")
  private String typeId;
  /**
   * 危险源类型(关联字典表id)
   */
  @ApiModelProperty(value = "危险源类型")
  private String typeName;
  /**
   * 危险源关联类型(1-设备；2-空间)
   */
  @ApiModelProperty(value = "危险源关联类型(1-设备；2-空间)" , example = "0")
  private Integer relationType;
  /**
   * 关联设备id
   */
  @ApiModelProperty(value = "关联设备id")
  private String relationEquipmentId;
  /**
   * 关联设备id
   */
  @ApiModelProperty(value = "关联设备名称")
  private String relationEquipmentName;
  /**
   * 关联空间id(作业区域)
   */
  @ApiModelProperty(value = "关联空间id")
  private String relationSpaceId;

  /**
   * 关联空间id(作业区域)
   */
  @ApiModelProperty(value = "空间编号（列表编号使用此值）")
  private String relationSpaceCode;

  /**
   * 空间位置
   */
  @ApiModelProperty(value = "空间位置")
  private String spaceLocation;

  @ApiModelProperty(value = "关联车间场所类型id")
  private String relationSpaceTypeId;

  @ApiModelProperty(value = "关联车间场所类型名称")
  private String relationSpaceTypeName;

  @ApiModelProperty(value = "关联车间场所id")
  private String relationWorkshopId;

  @ApiModelProperty(value = "关联车间场所名称")
  private String relationWorkshopName;

  /**
   * 是否为重大危险源(0-否，1是)
   */
  @ApiModelProperty(value = "是否为重大危险源(0-否，1是)")
  private String isMajor;
  /**
   * 危险等级(关联字典表id)
   */
  @ApiModelProperty(value = "危险等级(关联字典表id)")
  private String riskLevelId;

  @ApiModelProperty(value = "危险等级名称")
  private String riskLevelName;
  /**
   * 固有风险等级(关联字典表id)
   */
  @ApiModelProperty(value = "固有风险等级(关联字典表id)")
  private String inherentLevelId;

  @ApiModelProperty(value = "固有风险等级名称")
  private String inherentLevelName;
  /**
   * 现实风险等级(关联字典表id)
   */
  @ApiModelProperty(value = "现实风险等级(关联字典表id)(编辑必填)")
  private String realLevelId;

  @ApiModelProperty(value = "现实风险等级名称")
  private String realLevelName;

  @ApiModelProperty(value = "现实风险辨识方法  1-lec; 2-ls")
  private Integer identificationMethod;

  private Float lecL;

  private Float lecE;

  private Float lecC;

  private Float lsL;

  private Float lsS;
  /**
   * 管控层级(关联字典表id)
   */
  @ApiModelProperty(value = "管控层级(关联字典表id)")
  private String controlLevelId;

  @ApiModelProperty(value = "管控层级")
  private String controlLevelName;

  /**
   * 管控状态(关联字典表id)
   */
  @ApiModelProperty(value = "管控状态(关联字典表id)")
  private String controlStatusId;

  @ApiModelProperty(value = "管控状态(关联字典表id)")
  private String controlStatusName;

  /**
   * 检查频次(关联字典表id)
   */
  @ApiModelProperty(value = "检查频次(关联字典表id)(编辑必填)")
  private String checkFrequencyId;

  @ApiModelProperty(value = "检查频次(关联字典表id)")
  private String checkFrequencyName;

  /**
   * 控制依据
   */
  @ApiModelProperty(value = "控制依据")
  private String controlBasis;
  /**
   * 管控措施
   */
  @ApiModelProperty(value = "管控措施")
  private String controlMeasures;
  /**
   * 改进措施
   */
  @ApiModelProperty(value = "改进措施")
  private String improvementPlan;

  @ApiModelProperty(value = "管控部门")
  private String ownerDepartment;

  @ApiModelProperty(value = "责任人")
  private String ownerUserName;

  @ApiModelProperty(value = "风险点id")
  private String pointId;
  @ApiModelProperty(value = "风险点名称")
  private String pointName;

  @ApiModelProperty(value = "进一步管控措施")
  private String furtherControlMeasures;

}
