package com.testor.module.accident.model.req;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.module.accident.constant.AccidentStatisticsType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author zhangyangfan@testor.com.cn
 * @version 1.0
 * @description: 事故统计请求参数
 * @date 2022/5/12 15:00
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "事故统计请求参数")
public class AccidentStatisticsReq {

    @ApiModelProperty(value = "统计类型")
    private AccidentStatisticsType statisticsType;

    @ApiModelProperty(value = "区域公司id")
    private String regionalCompanyId;

    @ApiModelProperty(value = "基层单位id")
    private String basicUnitId;

    @ApiModelProperty(value = "开始时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;

    @ApiModelProperty(value = "结束时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    @ApiModelProperty(value = "单位id")
    private String deptId;

}
