package com.testor.module.contractor.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 承包商考核评价-是否涉及否决项枚举
 */
@Getter
@AllArgsConstructor
public enum ContractorEvaluateIfVetoEnum {
    NONE("0", "无"),
    REPEAT_HAZARD("1", "重复隐患"),
    ACCIDENT("2", "安全事故");

    private String code;
    private String name;

    public static ContractorEvaluateIfVetoEnum getByCode(String code) {
        for (ContractorEvaluateIfVetoEnum item : ContractorEvaluateIfVetoEnum.values()) {
            if (item.getCode().equals(code)) {
                return item;
            }
        }
        return null;
    }
}
