package com.testor.module.contractor.ledger.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.contractor.ledger.model.domain.TContractorInfo;
import com.testor.module.contractor.ledger.model.dto.TContractorInfoParam;
import com.testor.module.contractor.ledger.model.dto.TContractorInfoDelParam;
import com.testor.module.contractor.ledger.service.TContractorInfoService;

/**
 * 承包商信息Controller
 *
 * @author testor-framework
 * @date 2024-11-22 13:41:30
 */
@RestController
@RequestMapping("/contractor/info")
@Api(value = "TContractorInfo", tags = "承包商信息")
@Slf4j
public class TContractorInfoController extends SuperController
{
    @Autowired
    private TContractorInfoService tContractorInfoService;

    /* Generated Method*/
	@ApiOperation(value = "新增 承包商信息", notes = "Add TContractorInfo")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorInfo>addEntity(@RequestBody TContractorInfo addRequest) {
		BaseResponse<TContractorInfo> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TContractorInfo data=BeanHelper.beanToBean(addRequest,  TContractorInfo.class);
			data.setId(id);
			boolean result= tContractorInfoService.save(data);
			if(result){
                TContractorInfo newEntity = new TContractorInfo();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商信息 ", notes = "Get TContractorInfo By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorInfo> getById(String id){
		BaseResponse<TContractorInfo> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TContractorInfo data= tContractorInfoService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 承包商信息 ", notes = "Update TContractorInfo By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorInfo updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorInfo data=BeanHelper.beanToBean(updateRequest, TContractorInfo.class);
			boolean result= tContractorInfoService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 承包商信息 ", notes = "delete TContractorInfo By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorInfoDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			boolean result = tContractorInfoService.deleteEntity(deleteRequest.getId());
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除承包商信息", notes = "delete TContractorInfo by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorInfoDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorInfo> tContractorInfoList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorInfo data= new TContractorInfo();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorInfoList.add(data);
			}
			boolean result = tContractorInfoService.updateBatchById(tContractorInfoList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商信息 分页列表", notes = "List TContractorInfo with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorInfo>>listEntity(TContractorInfoParam param){
		BaseResponse<BaseResponseList<TContractorInfo>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TContractorInfo> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorInfo> queryWrapper=this.createQuery(param);
		Page<TContractorInfo> resultList= tContractorInfoService.page(resultPage,queryWrapper);
		BaseResponseList<TContractorInfo> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商信息 列表", notes = "List TContractorInfo all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorInfo>>listAllEntity(TContractorInfoParam param){
		BaseResponse<BaseResponseList<TContractorInfo>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorInfo> queryWrapper=this.createQuery(param);
		List<TContractorInfo> resultList=tContractorInfoService.list(queryWrapper);
		BaseResponseList<TContractorInfo> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TContractorInfo> createQuery(TContractorInfoParam queryParam){
		QueryWrapper<TContractorInfo> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getName())){
			queryWrapper.like(TContractorInfo.NAME,queryParam.getName());
		}
		if(StringHelper.isNotEmpty(queryParam.getCreditCode())){
			queryWrapper.eq(TContractorInfo.CREDIT_CODE,queryParam.getCreditCode());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getRegCapital())){
			queryWrapper.eq(TContractorInfo.REG_CAPITAL,queryParam.getRegCapital());
		}
		if(StringHelper.isNotEmpty(queryParam.getProvince())){
			queryWrapper.eq(TContractorInfo.PROVINCE,queryParam.getProvince());
		}
		if(StringHelper.isNotEmpty(queryParam.getCity())){
			queryWrapper.eq(TContractorInfo.CITY,queryParam.getCity());
		}
		if(StringHelper.isNotEmpty(queryParam.getAddr())){
			queryWrapper.eq(TContractorInfo.ADDR,queryParam.getAddr());
		}
		if(StringHelper.isNotEmpty(queryParam.getLegalPerson())){
			queryWrapper.eq(TContractorInfo.LEGAL_PERSON,queryParam.getLegalPerson());
		}
		if(StringHelper.isNotEmpty(queryParam.getTel())){
			queryWrapper.eq(TContractorInfo.TEL,queryParam.getTel());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getRegDate())){
			queryWrapper.eq(TContractorInfo.REG_DATE,queryParam.getRegDate());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getValidPeriod())){
			queryWrapper.eq(TContractorInfo.VALID_PERIOD,queryParam.getValidPeriod());
		}
		if(StringHelper.isNotEmpty(queryParam.getBizScope())){
			queryWrapper.eq(TContractorInfo.BIZ_SCOPE,queryParam.getBizScope());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TContractorInfo.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TContractorInfo.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TContractorInfo.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
