package com.testor.module.contractor.ledger.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 工器具台账对象 t_contractor_tools
 * 
 * @author testor-framework
 * @date 2024-11-19 10:30:09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_tools")
@ApiModel(value = "TContractorTools对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorTools extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 工器具名称
 */
  @ApiModelProperty(value = "工器具名称")

  @TableField("tools_name")
  private String toolsName;

  /**
   * 工器具名称下拉选项值
   */
  @ApiModelProperty(value = "工器具名称下拉选项值")
  @TableField(exist = false)
  private String nameSelect;

/**
 * 类别id（数据字典id）
 */
  @ApiModelProperty(value = "类别id（数据字典id）")

  @TableField("type_id")
  private String typeId;
/**
 * 类别
 */
  @ApiModelProperty(value = "类别")
  @Translation(type = TransConstant.DICT_ID_TO_LABEL,mapper = "typeId")
  @TableField("type")
  private String type;
/**
 * 型号
 */
  @ApiModelProperty(value = "型号")

  @TableField("model")
  private String model;
/**
 * 数量
 */
  @ApiModelProperty(value = "数量" , example = "0")

  @TableField("num")
  private Long num;
/**
 * 用途
 */
  @ApiModelProperty(value = "用途")

  @TableField("purpose")
  private String purpose;
/**
 * 检查情况 0未检查 1已检查
 */
  @ApiModelProperty(value = "检查情况 0未检查 1已检查")

  @TableField("check_status")
  private String checkStatus;
/**
 * 检查日期
 */
  @ApiModelProperty(value = "检查日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @TableField("check_time")
  private Date checkTime;
/**
 * 是否合格 0 不合格 1 合格
 */
  @ApiModelProperty(value = "是否合格 0 不合格 1 合格")

  @TableField("is_pass")
  private String isPass;
/**
 * 合格证，文件id
 */
  @ApiModelProperty(value = "合格证，文件id，多个用,分隔")

  @TableField("compliance_certificate")
  private String complianceCertificate;

  /**
   * 合格证，文件url，多个用,分隔
   */
  @ApiModelProperty(value = "合格证，文件url，多个用,分隔")
  @TableField(exist = false)
  @Translation(type = TransConstant.FILE_ID_TO_URL,mapper = "complianceCertificate")
  private String complianceCertificateUrl;

  /**
   * 所属企业id
   */
  @ApiModelProperty(value = "所属企业id")

  @TableField("org_id")
  private String orgId;

  public static final String ID ="id";
  public static final String TOOLS_NAME ="tools_name";
  public static final String TYPE_ID ="type_id";
  public static final String TYPE ="type";
  public static final String MODEL ="model";
  public static final String NUM ="num";
  public static final String PURPOSE ="purpose";
  public static final String CHECK_STATUS ="check_status";
  public static final String CHECK_TIME ="check_time";
  public static final String IS_PASS ="is_pass";
  public static final String COMPLIANCE_CERTIFICATE ="compliance_certificate";
  public static final String ORG_ID ="org_id";


}
