package com.testor.module.contractor.manage.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.contractor.manage.model.domain.TContractorDailyPlanContent;
import com.testor.module.contractor.manage.model.dto.TContractorDailyPlanContentParam;
import com.testor.module.contractor.manage.model.dto.TContractorDailyPlanContentDelParam;
import com.testor.module.contractor.manage.service.TContractorDailyPlanContentService;

/**
 * 日常管理-每日工作计划-工作内容Controller
 *
 * @author testor-framework
 * @date 2024-11-28 15:40:20
 */
@RestController
@RequestMapping("/manage/content")
@Api(value = "TContractorDailyPlanContent", tags = "日常管理-每日工作计划-工作内容")
@Slf4j
public class TContractorDailyPlanContentController extends SuperController
{
    @Autowired
    private TContractorDailyPlanContentService tContractorDailyPlanContentService;

    /* Generated Method*/
	@ApiOperation(value = "新增 日常管理-每日工作计划-工作内容", notes = "Add TContractorDailyPlanContent")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorDailyPlanContent>addEntity(@RequestBody TContractorDailyPlanContent addRequest) {
		BaseResponse<TContractorDailyPlanContent> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TContractorDailyPlanContent data=BeanHelper.beanToBean(addRequest,  TContractorDailyPlanContent.class);
			data.setId(id);
			boolean result= tContractorDailyPlanContentService.save(data);
			if(result){
                TContractorDailyPlanContent newEntity = new TContractorDailyPlanContent();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理-每日工作计划-工作内容 ", notes = "Get TContractorDailyPlanContent By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorDailyPlanContent> getById(String id){
		BaseResponse<TContractorDailyPlanContent> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TContractorDailyPlanContent data= tContractorDailyPlanContentService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 日常管理-每日工作计划-工作内容 ", notes = "Update TContractorDailyPlanContent By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorDailyPlanContent updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorDailyPlanContent data=BeanHelper.beanToBean(updateRequest, TContractorDailyPlanContent.class);
			boolean result= tContractorDailyPlanContentService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 日常管理-每日工作计划-工作内容 ", notes = "delete TContractorDailyPlanContent By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorDailyPlanContentDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorDailyPlanContent data= new TContractorDailyPlanContent();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tContractorDailyPlanContentService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除日常管理-每日工作计划-工作内容", notes = "delete TContractorDailyPlanContent by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorDailyPlanContentDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorDailyPlanContent> tContractorDailyPlanContentList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorDailyPlanContent data= new TContractorDailyPlanContent();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorDailyPlanContentList.add(data);
			}
			boolean result = tContractorDailyPlanContentService.updateBatchById(tContractorDailyPlanContentList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理-每日工作计划-工作内容 分页列表", notes = "List TContractorDailyPlanContent with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorDailyPlanContent>>listEntity(TContractorDailyPlanContentParam param){
		BaseResponse<BaseResponseList<TContractorDailyPlanContent>>baseResponse=new BaseResponse<>();
		Page<TContractorDailyPlanContent> resultList= tContractorDailyPlanContentService.listEntity(param);
		BaseResponseList<TContractorDailyPlanContent> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理-每日工作计划-工作内容 列表", notes = "List TContractorDailyPlanContent all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorDailyPlanContent>>listAllEntity(TContractorDailyPlanContentParam param){
		BaseResponse<BaseResponseList<TContractorDailyPlanContent>>baseResponse=new BaseResponse<>();
		List<TContractorDailyPlanContent> resultList=tContractorDailyPlanContentService.listAllEntity(param);
		BaseResponseList<TContractorDailyPlanContent> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

}
