package com.testor.module.contractor.manage.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 日常管理-每日工作计划-变更对象 t_contractor_daily_plan_change
 * 
 * @author testor-framework
 * @date 2024-11-29 10:10:44
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_daily_plan_change")
@ApiModel(value = "TContractorDailyPlanChange对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorDailyPlanChange extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键id
 */
  @ApiModelProperty(value = "主键id")

  @TableId("id")
  private String id;
/**
 * 日常工作计划id
 */
  @ApiModelProperty(value = "日常工作计划id")

  @TableField("plan_id")
  private String planId;
/**
 * 分类 0停工 1复工
 */
  @ApiModelProperty(value = "分类 0停工 1复工")

  @TableField("type")
  private String type;
/**
 * 流程实例ID
 */
  @ApiModelProperty(value = "流程实例ID")

  @TableField("process_id")
  private String processId;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态")

  @TableField("process_status")
  private String processStatus;
/**
 * 申请单位
 */
  @ApiModelProperty(value = "申请单位")

  @TableField("org_id")
  private String orgId;
/**
 * 申请时间
 */
  @ApiModelProperty(value = "申请时间")

  @TableField("apply_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date applyTime;
/**
 * 变更等级id（数据字典id）
 */
  @ApiModelProperty(value = "变更等级id（数据字典id）")

  @TableField("change_level_id")
  private String changeLevelId;
/**
 * 变更等级
 */
  @ApiModelProperty(value = "变更等级")

  @TableField("change_level")
  @Translation(type = TransConstant.DICT_ID_TO_LABEL,mapper = "changeLevelId")
  private String changeLevel;
/**
 * 变更类型id（数据字典id）
 */
  @ApiModelProperty(value = "变更类型id（数据字典id）")

  @TableField("change_type_id")
  private String changeTypeId;
/**
 * 变更类型
 */
  @ApiModelProperty(value = "变更类型")

  @TableField("change_type")
  @Translation(type = TransConstant.DICT_ID_TO_LABEL,mapper = "changeTypeId")
  private String changeType;
/**
 * 作业开始时间
 */
  @ApiModelProperty(value = "作业开始时间")

  @TableField("work_start_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date workStartTime;
/**
 * 作业结束时间
 */
  @ApiModelProperty(value = "作业结束时间")

  @TableField("work_finish_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date workFinishTime;
/**
 * 变更原因
 */
  @ApiModelProperty(value = "变更原因")

  @TableField("reason")
  private String reason;
/**
 * 变更作业内容
 */
  @ApiModelProperty(value = "变更作业内容")

  @TableField("work_content")
  private String workContent;
/**
 * 涉及风险类型
 */
  @ApiModelProperty(value = "涉及风险类型")

  @TableField("risk_type")
  private String riskType;
/**
 * 主要控制措施
 */
  @ApiModelProperty(value = "主要控制措施")

  @TableField("measure")
  private String measure;

  public static final String ID ="id";
  public static final String PLAN_ID ="plan_id";
  public static final String TYPE ="type";
  public static final String PROCESS_ID ="process_id";
  public static final String PROCESS_STATUS ="process_status";
  public static final String ORG_ID ="org_id";
  public static final String APPLY_TIME ="apply_time";
  public static final String CHANGE_LEVEL_ID ="change_level_id";
  public static final String CHANGE_LEVEL ="change_level";
  public static final String CHANGE_TYPE_ID ="change_type_id";
  public static final String CHANGE_TYPE ="change_type";
  public static final String WORK_START_TIME ="work_start_time";
  public static final String WORK_FINISH_TIME ="work_finish_time";
  public static final String REASON ="reason";
  public static final String WORK_CONTENT ="work_content";
  public static final String RISK_TYPE ="risk_type";
  public static final String MEASURE ="measure";


}
