package com.testor.module.contractor.manage.model.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import com.testor.module.contractor.manage.model.domain.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;
import java.util.Map;

@Data
@EqualsAndHashCode(callSuper = true)
public class TContractorDailyPlanDTO extends TContractorDailyPlan {

    @ApiModelProperty("特殊作业管理")
    private List<TContractorDailyPlanContent> specialOperationsManagementList;

    @ApiModelProperty("安全技术管理")
    private List<TContractorDailyPlanContent> safetyTechnologyManagement;

    @ApiModelProperty("变更信息")
    private TContractorDailyPlanChange tContractorDailyPlanChange;

    @ApiModelProperty("停工信息")
    private TContractorDailyPlanStopRestartWork tContractorDailyPlanStopWork;

    @ApiModelProperty("复工信息")
    private TContractorDailyPlanStopRestartWork tContractorDailyPlanRestartWork;

    @ApiModelProperty("检查状态")
    private String checkStatus;

    @TableField(exist = false)
    @Translation(type = TransConstant.CONTRACTOR_ID_TO_NAME,mapper = "contractorId")
    private String contractorName;

    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("隐患数量")
    private Long hazardCount;

    @ApiModelProperty("审批类型")
    private String approvalType;

    private Map<String,Object> map;

    private String taskId;

    @ApiModelProperty(value = "物料ids")
    private List<TContractorDailyPlanMaterial> materialList;

    @ApiModelProperty(value = "防护用品ids")
    private List<TContractorDailyPlanProtective> protectiveList;

    @ApiModelProperty(value = "工器具台账ids")
    private List<TContractorDailyPlanTools> toolsList;

    /**
     * 准入工器具关联id
     */
    @ApiModelProperty(value = "准入工器具关联id")
    private String allowToolsId;
    /**
     * 准入物料关联id
     */
    @ApiModelProperty(value = "准入物料关联id")
    private String allowMaterialId;
    /**
     * 准入防护用品关联id
     */
    @ApiModelProperty(value = "准入防护用品关联id")
    private String allowProtectiveId;


}