package com.testor.module.duty.model.dto;


import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * 人员实体
 */

@Data
public class Person {
    @ApiModelProperty(value = "人员id")
    private String id ;
    @ApiModelProperty(value = "班次", required = true)
    private String classes ;
    @ApiModelProperty(value = "值班人姓名", required = true)
    private String name ;
    @ApiModelProperty(value = "值班人所属部门", required = true)
    private String deptName ;
    @ApiModelProperty(value = "值班人所属部门id")
    private String deptId;
    @ApiModelProperty(value = "值班人电话", required = true)
    private String phone ;
    @ApiModelProperty(value = "调整原因")
    private String adjustCause ;
    @ApiModelProperty("关联id")
    private String refId;
    @ApiModelProperty("创建时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;
    @ApiModelProperty("是否领导")
    private String isLeader;
    @ApiModelProperty(value = "值班人员id")
    private String userId ;
    @ApiModelProperty(value = "是否创建了值班日志")
    private String isCreateLog;
    @ApiModelProperty(value = "日志是否暂存")
    private String dutyLogDraft;
    @ApiModelProperty(value = "日志是否暂存")
    private String dutyLogId;
}
