package com.testor.module.emergency.model.domain;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 应急预案演练对象 t_emergency_rehearsal
 *
 * @author testor-framework
 * @date 2022-12-02 15:50:38
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_emergency_rehearsal")
@ApiModel(value = "TEmergencyRehearsal对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TEmergencyRehearsal extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @ApiModelProperty(value = "id")

    @TableId("id")
    private String id;
    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "组织机构id")

    @TableField("org_id")
    private String orgId;
    /**
     * 演练计划名称
     */
    @ApiModelProperty(value = "演练计划名称")

    @TableField("rehearsal_plan_name")
    private String rehearsalPlanName;
    /**
     * 模拟事件名称
     */
    @ApiModelProperty(value = "模拟事件名称")

    @TableField("simulation_event_name")
    private String simulationEventName;
    /**
     * 模拟事件类型
     */
    @ApiModelProperty(value = "模拟事件类型")

    @TableField("simulation_event_type")
    private String simulationEventType;
    /**
     * 模拟事件对象名称
     */
    @ApiModelProperty(value = "模拟事件对象名称")

    @TableField("simulation_event_object")
    private String simulationEventObject;
    /**
     * 模拟事件对象id
     */
    @ApiModelProperty(value = "模拟事件对象id")

    @TableField("simulation_event_object_id")
    private String simulationEventObjectId;
    /**
     * 具体对象id
     */
    @ApiModelProperty(value = "具体对象id")
    @TableField("specific_object_id")
    private String specificObjectId;

    /**
     * 具体对象名称
     */
    @ApiModelProperty(value = "具体对象名称")
    @TableField("specific_object")
    private String specificObject;

    /**
     * 模拟事件位置
     */
    @ApiModelProperty(value = "模拟事件位置")

    @TableField("simulation_event_place")
    private String simulationEventPlace;
    /**
     * 模拟事件描述
     */
    @ApiModelProperty(value = "模拟事件描述")

    @TableField("simulation_event_describe")
    private String simulationEventDescribe;
    /**
     * 演练类型
     */
    @ApiModelProperty(value = "演练类型")

    @TableField("rehearsal_type")
    private String rehearsalType;
    /**
     * 演练类型字典key
     */
    @ApiModelProperty(value = "演练类型字典key")

    @TableField("rehearsal_type_key")
    private String rehearsalTypeKey;
    /**
     * 演练方式
     */
    @ApiModelProperty(value = "演练方式")

    @TableField("rehearsal_way")
    private String rehearsalWay;
    /**
     * 演练方式字典key
     */
    @ApiModelProperty(value = "演练方式字典key")

    @TableField("rehearsal_way_key")
    private String rehearsalWayKey;
    /**
     * 总指挥
     */
    @ApiModelProperty(value = "总指挥")

    @TableField("total_command")
    private String totalCommand;
    /**
     * 总指挥id
     */
    @ApiModelProperty(value = "总指挥id")

    @TableField("total_command_id")
    private String totalCommandId;
    /**
     * 参与人员
     */
    @ApiModelProperty(value = "参与人员")

    @TableField("participant")
    private String participant;
    /**
     * 参与人员ids
     */
    @ApiModelProperty(value = "参与人员ids")

    @TableField("participant_ids")
    private String participantIds;
    /**
     * 流程实例id
     */
    @ApiModelProperty(value = "流程实例id")

    @TableField("process_id")
    private String processId;
    /**
     * 演练计划开始时间
     */
    @ApiModelProperty(value = "演练计划开始时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("start_time")
    private Date startTime;

    /**
     * 演练计划结束时间
     */
    @ApiModelProperty(value = "演练计划结束时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("end_time")
    private Date endTime;

    /**
     * 演练状态
     */
    @ApiModelProperty(value = "演练状态")
    @TableField("rehearsal_status")
    private String rehearsalStatus;
    public static final String ID = "id";
    public static final String ORG_ID = "org_id";
    public static final String REHEARSAL_PLAN_NAME = "rehearsal_plan_name";
    public static final String SIMULATION_EVENT_NAME = "simulation_event_name";
    public static final String SIMULATION_EVENT_TYPE = "simulation_event_type";
    public static final String SIMULATION_EVENT_OBJECT = "simulation_event_object";
    public static final String SIMULATION_EVENT_OBJECT_ID = "simulation_event_object_id";
    public static final String SPECIFIC_OBJECT_ID = "specific_object_id";
    public static final String SPECIFIC_OBJECT = "specific_object";
    public static final String SIMULATION_EVENT_PLACE = "simulation_event_place";
    public static final String SIMULATION_EVENT_DESCRIBE = "simulation_event_describe";
    public static final String REHEARSAL_TYPE = "rehearsal_type";
    public static final String REHEARSAL_TYPE_KEY = "rehearsal_type_key";
    public static final String REHEARSAL_WAY = "rehearsal_way";
    public static final String REHEARSAL_WAY_KEY = "rehearsal_way_key";
    public static final String TOTAL_COMMAND = "total_command";
    public static final String TOTAL_COMMAND_ID = "total_command_id";
    public static final String PARTICIPANT = "participant";
    public static final String PARTICIPANT_IDS = "participant_ids";
    public static final String FLOW_ID = "flow_id";
    public static final String START_TIME = "start_time";
    public static final String END_TIME = "end_time";


}
