package com.testor.module.emergency.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 应急演练附件对象 t_emergency_rehearsal_accessory
 *
 * @author testor-framework
 * @date 2022-12-07 10:09:12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_emergency_rehearsal_accessory")
@ApiModel(value = "TEmergencyRehearsalAccessory对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TEmergencyRehearsalAccessory extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键id
     */
    @ApiModelProperty(value = "主键id")

    @TableId("id")
    private String id;
    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "组织机构id")

    @TableField("org_id")
    private String orgId;
    /**
     * 应急演练id
     */
    @ApiModelProperty(value = "应急演练id")

    @TableField("rehearsal_id")
    private String rehearsalId;
    /**
     * 附件名
     */
    @ApiModelProperty(value = "附件名")

    @TableField("accessory_name")
    private String accessoryName;
    /**
     * 附件地址
     */
    @ApiModelProperty(value = "附件地址")

    @TableField("accessory_path")
    private String accessoryPath;
    /**
     * 附件扩展名
     */
    @ApiModelProperty(value = "附件扩展名")

    @TableField("accessory_ext")
    private String accessoryExt;
    /**
     * 附件id
     */
    @ApiModelProperty(value = "附件id")

    @TableField("accessory_id")
    private String accessoryId;

    public static final String ID = "id";
    public static final String ORG_ID = "org_id";
    public static final String REHEARSAL_ID = "rehearsal_id";
    public static final String ACCESSORY_NAME = "accessory_name";
    public static final String ACCESSORY_PATH = "accessory_path";
    public static final String ACCESSORY_EXT = "accessory_ext";
    public static final String ACCESSORY_ID = "accessory_id";


}
