package com.testor.module.emergency.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 应急救援小组人员对象 t_emergency_working_user
 *
 * @author testor-framework
 * @date 2022-11-17 11:52:10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_emergency_working_user")
@ApiModel(value = "TEmergencyWorkingUser对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TEmergencyWorkingUser extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id")

    @TableField("user_id")
    private String userId;
    /**
     * 应急救援组id
     */
    @ApiModelProperty(value = "应急救援组id")

    @TableField("group_id")
    private String groupId;
    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "组织机构id")

    @TableField("org_id")
    private String orgId;
    /**
     * id
     */
    @ApiModelProperty(value = "id")

    @TableId("id")
    private String id;
    /**
     * 角色名称
     */
    @ApiModelProperty(value = "角色名称")

    @TableField("role_name")
    private String roleName;
    /**
     * 角色id
     */
    @ApiModelProperty(value = "角色id")

    @TableField("role_id")
    private String roleId;
    /**
     * 电话
     */
    @ApiModelProperty(value = "电话")

    @TableField("phone")
    private String phone;
    /**
     * 用户名称
     */
    @ApiModelProperty(value = "用户名称")

    @TableField("user_name")
    private String userName;

    public static final String USER_ID = "user_id";
    public static final String GROUP_ID = "group_id";
    public static final String ORG_ID = "org_id";
    public static final String ID = "id";
    public static final String ROLE_NAME = "role_name";
    public static final String ROLE_ID = "role_id";
    public static final String PHONE = "phone";
    public static final String USER_NAME = "user_name";


}
