package com.testor.module.emergency.model.execl;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author rsq
 * @program zlmy_boot
 * @return
 **/
@Data
public class ExportGoods {

    @ExcelProperty(value = "序号", index = 0)
    private Integer serialNumber;

    @ExcelProperty(value = "基层企业", index = 1)
    private String orgName;

    @ExcelProperty(value = "经营部", index = 2)
    private String jybName;

    @ExcelProperty(value = "大区/平台", index = 3)
    private String dqName;

    @ExcelProperty(value = "物资类型", index = 4)
    private String goodsTypeName;

    @ExcelProperty(value = "物资名称", index = 5)
    private String goodsName;

    @ExcelProperty(value = "规格或型号", index = 6)
    private String specification;

    @ExcelProperty(value = "应备数量", index = 7)
    private Integer reserveNum;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ExcelProperty(value = "配备时间", index = 8)
    private Date reserveDate;

    @ExcelProperty(value = "存放位置", index = 9)
    private String spaceName;

    @ExcelProperty(value = "详细位置", index = 10)
    private String position;

    @ExcelProperty(value = "完好状态", index = 11)
    private String goodCondition;

    @ExcelProperty(value = "备注", index = 12)
    private String des;

    @ExcelProperty(value = "点检周期", index = 13)
    private String cycle;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ExcelProperty(value = "下一点检时间", index = 14)
    private Date nextCheckTime;


}
